/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.client;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.hardcorerevival.client.GuiHelper;
import net.blay09.mods.hardcorerevival.client.HardcoreRevivalClient;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.network.AcceptFateMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class KnockoutScreen
extends Screen {
    private Button buttonDie;
    private float enableButtonTimer;

    protected KnockoutScreen() {
        super((Component)Component.translatable((String)"gui.hardcorerevival.knocked_out"));
    }

    protected void init() {
        this.buttonDie = Button.builder((Component)Component.translatable((String)"gui.hardcorerevival.die", (Object[])new Object[]{""}), it -> {
            this.buttonDie.playDownSound(Minecraft.getInstance().getSoundManager());
            Balm.getNetworking().sendToServer((CustomPacketPayload)new AcceptFateMessage());
        }).pos(this.width / 2 - 100, this.height / 2 - 30).size(200, 20).build();
        this.buttonDie.active = false;
        this.buttonDie.visible = HardcoreRevivalConfig.getActive().allowAcceptingFate;
        this.addRenderableWidget((GuiEventListener)this.buttonDie);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            this.enableButtonTimer += partialTicks;
            if (this.enableButtonTimer >= 40.0f) {
                this.buttonDie.active = true;
                this.buttonDie.setMessage((Component)Component.translatable((String)"gui.hardcorerevival.die", (Object[])new Object[]{""}));
            } else if (this.enableButtonTimer >= 30.0f) {
                this.buttonDie.setMessage((Component)Component.translatable((String)"gui.hardcorerevival.die", (Object[])new Object[]{"..."}));
            } else if (this.enableButtonTimer >= 20.0f) {
                this.buttonDie.setMessage((Component)Component.translatable((String)"gui.hardcorerevival.die", (Object[])new Object[]{".."}));
            } else if (this.enableButtonTimer >= 10.0f) {
                this.buttonDie.setMessage((Component)Component.translatable((String)"gui.hardcorerevival.die", (Object[])new Object[]{"."}));
            }
            GuiHelper.renderKnockedOutTitle(guiGraphics, this.width);
            GuiHelper.renderDeathTimer(guiGraphics, this.width, this.height, HardcoreRevivalClient.isBeingRescued());
        } else if (this.buttonDie != null) {
            this.buttonDie.visible = false;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

