/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.api.PlayerAboutToKnockOutEvent;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.tag.ModItemTags;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class KnockoutHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(LivingDamageEvent.class, KnockoutHandler::onPlayerDamage);
        Balm.getEvents().onEvent(PlayerRespawnEvent.class, KnockoutHandler::onPlayerRespawn);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, KnockoutHandler::onPlayerTick);
    }

    public static void onPlayerDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            boolean wouldDie;
            ServerPlayer player = (ServerPlayer)livingEntity;
            DamageSource damageSource = event.getDamageSource();
            if (PlayerHardcoreRevivalManager.isKnockedOut((Player)player)) {
                Entity attacker = damageSource.getEntity();
                if (attacker instanceof Mob) {
                    Mob mob = (Mob)attacker;
                    mob.setTarget(null);
                }
                if (!damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !damageSource.is(HardcoreRevivalManager.NOT_RESCUED_IN_TIME)) {
                    event.setCanceled(true);
                }
                return;
            }
            boolean bl = wouldDie = player.getHealth() - event.getDamageAmount() <= 0.0f;
            if (wouldDie && KnockoutHandler.isKnockoutEnabledFor(player, damageSource)) {
                PlayerAboutToKnockOutEvent aboutToKnockOutEvent = new PlayerAboutToKnockOutEvent((Player)player, damageSource);
                Balm.getEvents().fireEvent((Object)aboutToKnockOutEvent);
                if (!aboutToKnockOutEvent.isCanceled()) {
                    event.setDamageAmount(Math.min(event.getDamageAmount(), Math.max(0.0f, player.getHealth() - 1.0f)));
                    HardcoreRevivalManager.knockout((Player)player, damageSource);
                }
            }
        }
    }

    private static boolean holdsDeathProtectionItem(ServerPlayer player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemStack = player.getItemInHand(hand);
            if (!itemStack.is(ModItemTags.PASSTHROUGH_DEATH_WHEN_HELD)) continue;
            return true;
        }
        return false;
    }

    private static boolean isKnockoutEnabledFor(ServerPlayer player, DamageSource damageSource) {
        ResourceLocation entityTypeId;
        MinecraftServer server = player.getServer();
        if (server == null) {
            return false;
        }
        boolean canDamageSourceKnockout = !damageSource.is(DamageTypes.FELL_OUT_OF_WORLD) && !damageSource.is(HardcoreRevivalManager.NOT_RESCUED_IN_TIME);
        ResourceLocation damageSourceId = player.getServer().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getKey((Object)damageSource.type());
        if (!canDamageSourceKnockout || HardcoreRevivalConfig.getActive().instantDeathSources.contains(damageSourceId)) {
            return false;
        }
        Entity attacker = damageSource.getEntity();
        if (attacker != null && HardcoreRevivalConfig.getActive().instantDeathEntityTypes.contains(entityTypeId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)attacker.getType()))) {
            return false;
        }
        if (HardcoreRevivalConfig.getActive().disableInSingleplayer && server.isSingleplayer() && server.getPlayerCount() == 1) {
            return false;
        }
        if (HardcoreRevivalConfig.getActive().disableInLonelyMultiplayer && !server.isSingleplayer() && server.getPlayerCount() == 1) {
            return false;
        }
        return !KnockoutHandler.holdsDeathProtectionItem(player);
    }

    public static void onPlayerTick(ServerPlayer player) {
        if (PlayerHardcoreRevivalManager.isKnockedOut((Player)player) && player.isAlive()) {
            int maxTicksUntilDeath;
            player.setHealth(1.0f);
            PlayerHardcoreRevivalManager.setKnockoutTicksPassed((Player)player, PlayerHardcoreRevivalManager.getKnockoutTicksPassed((Player)player) + 1);
            if (player.tickCount % 20 == 0) {
                Balm.getHooks().setForcedPose((Player)player, (Pose)(PlayerHardcoreRevivalManager.isKnockedOut((Player)player) ? Pose.FALL_FLYING : null));
            }
            if ((maxTicksUntilDeath = HardcoreRevivalConfig.getActive().secondsUntilDeath * 20) > 0 && PlayerHardcoreRevivalManager.getKnockoutTicksPassed((Player)player) >= maxTicksUntilDeath) {
                HardcoreRevivalManager.notRescuedInTime((Player)player);
            }
        }
    }

    public static void onPlayerRespawn(PlayerRespawnEvent event) {
        HardcoreRevivalManager.reset((Player)event.getNewPlayer());
    }
}

