/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.ChunkTrackingEvent;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.network.HardcoreRevivalDataMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class KnockoutSyncHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(ChunkTrackingEvent.Start.class, KnockoutSyncHandler::onStartChunkTracking);
    }

    public static void onStartChunkTracking(ChunkTrackingEvent.Start event) {
        MinecraftServer server = event.getLevel().getServer();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!PlayerHardcoreRevivalManager.isKnockedOut((Player)player)) continue;
            KnockoutSyncHandler.sendHardcoreRevivalData((Player)event.getPlayer(), (Player)player);
        }
    }

    public static void sendHardcoreRevivalDataToWatching(Player player) {
        HardcoreRevivalDataMessage message = new HardcoreRevivalDataMessage(player.getId(), PlayerHardcoreRevivalManager.isKnockedOut(player), PlayerHardcoreRevivalManager.getKnockoutTicksPassed(player), false);
        Balm.getNetworking().sendToTracking((Entity)player, (CustomPacketPayload)message);
        KnockoutSyncHandler.sendHardcoreRevivalData(player, player);
    }

    public static void sendHardcoreRevivalData(Player toPlayer, Player forPlayer) {
        KnockoutSyncHandler.sendHardcoreRevivalData(toPlayer, forPlayer, false);
    }

    public static void sendHardcoreRevivalData(Player toPlayer, Player forPlayer, boolean beingRescued) {
        HardcoreRevivalDataMessage message = new HardcoreRevivalDataMessage(forPlayer.getId(), PlayerHardcoreRevivalManager.isKnockedOut(forPlayer), PlayerHardcoreRevivalManager.getKnockoutTicksPassed(forPlayer), beingRescued);
        Balm.getNetworking().sendTo(toPlayer, (CustomPacketPayload)message);
    }
}

