/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.network.RevivalProgressMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class RescueHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(UseItemEvent.class, RescueHandler::onUseItem);
        Balm.getEvents().onEvent(UseBlockEvent.class, RescueHandler::onUseBlock);
        Balm.getEvents().onEvent(PlayerAttackEvent.class, RescueHandler::onAttack);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, RescueHandler::onPlayerTick);
    }

    public static void onUseItem(UseItemEvent event) {
        if (HardcoreRevivalManager.isRescuing(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void onUseBlock(UseBlockEvent event) {
        if (HardcoreRevivalManager.isRescuing(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void onAttack(PlayerAttackEvent event) {
        HardcoreRevivalManager.abortRescue(event.getPlayer());
    }

    public static void onPlayerTick(ServerPlayer player) {
        Player rescueTarget = PlayerHardcoreRevivalManager.getRescueTarget((Player)player);
        if (rescueTarget != null) {
            int knockoutTicksPassed = PlayerHardcoreRevivalManager.getKnockoutTicksPassed(rescueTarget);
            int maxTicksUntilDeath = HardcoreRevivalConfig.getActive().secondsUntilDeath * 20;
            if (!rescueTarget.isAlive() || maxTicksUntilDeath > 0 && knockoutTicksPassed >= maxTicksUntilDeath) {
                HardcoreRevivalManager.abortRescue((Player)player);
            } else {
                float dist = player.distanceTo((Entity)rescueTarget);
                if ((double)dist > HardcoreRevivalConfig.getActive().rescueDistance) {
                    HardcoreRevivalManager.abortRescue((Player)player);
                } else {
                    int rescueTime = PlayerHardcoreRevivalManager.getRescueTime((Player)player) + 1;
                    PlayerHardcoreRevivalManager.setRescueTime((Player)player, rescueTime);
                    PlayerHardcoreRevivalManager.setKnockoutTicksPassed(rescueTarget, knockoutTicksPassed - 1);
                    int maxRescueActionTicks = HardcoreRevivalConfig.getActive().rescueActionTicks;
                    int step = maxRescueActionTicks / 4;
                    if (rescueTime >= maxRescueActionTicks) {
                        HardcoreRevivalManager.finishRescue((Player)player);
                    } else if (rescueTime % step == 0) {
                        Balm.getNetworking().sendTo((Player)player, (CustomPacketPayload)new RevivalProgressMessage(rescueTarget.getId(), (float)rescueTime / (float)maxRescueActionTicks));
                        KnockoutSyncHandler.sendHardcoreRevivalData(rescueTarget, rescueTarget, true);
                    }
                }
            }
        }
    }
}

