/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.mixin;

import net.blay09.mods.hardcorerevival.MixinHooks;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class ServerGamePacketListenerImplMixin {
    @Inject(method={"handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleMovePlayer(ServerboundMovePlayerPacket packet, CallbackInfo ci) {
        ServerGamePacketListenerImpl netHandler = (ServerGamePacketListenerImpl)this;
        if (MixinHooks.shouldCancelMovement((Entity)netHandler.player)) {
            MixinHooks.handleProcessPlayerRotation(netHandler.player, packet);
            ci.cancel();
        }
    }

    @Inject(method={"handlePlayerAction(Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void handlePlayerAction(ServerboundPlayerActionPacket packet, CallbackInfo ci) {
        ServerGamePacketListenerImpl netHandler = (ServerGamePacketListenerImpl)this;
        switch (packet.getAction()) {
            case DROP_ALL_ITEMS: {
                if (!MixinHooks.shouldCancelTossAll((Player)netHandler.player)) break;
                ci.cancel();
                break;
            }
            case DROP_ITEM: {
                if (!MixinHooks.shouldCancelToss((Player)netHandler.player, netHandler.player.getInventory().getSelected())) break;
                ci.cancel();
            }
        }
    }
}

