/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.network;

import java.util.List;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class RescueMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<RescueMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hardcorerevival", (String)"rescue"));
    private final boolean active;

    public RescueMessage(boolean active) {
        this.active = active;
    }

    public static void encode(FriendlyByteBuf buf, RescueMessage message) {
        buf.writeBoolean(message.active);
    }

    public static RescueMessage decode(FriendlyByteBuf buf) {
        boolean active = buf.readBoolean();
        return new RescueMessage(active);
    }

    private static boolean isLookingTowards(Player player, Entity candidate) {
        double dz;
        double dy;
        double dx = candidate.getX() - player.getX();
        double dotProduct = player.getLookAngle().x * dx + player.getLookAngle().y * (dy = candidate.getY() - 1.0 - player.getY()) + player.getLookAngle().z * (dz = candidate.getZ() - player.getZ());
        return dotProduct > 0.0 && Math.abs(Math.acos(dotProduct / Math.sqrt(dx * dx + dy * dy + dz * dz))) < 1.0471975511965976;
    }

    public static void handle(ServerPlayer player, RescueMessage message) {
        if (player == null || !player.isAlive() || player.isSpectator() || PlayerHardcoreRevivalManager.isKnockedOut((Player)player)) {
            return;
        }
        if (message.active) {
            double range = HardcoreRevivalConfig.getActive().rescueDistance;
            List candidates = player.level().getEntitiesOfClass(Player.class, player.getBoundingBox().inflate(range), p -> {
                if (p == null || !PlayerHardcoreRevivalManager.isKnockedOut(p)) {
                    return false;
                }
                if (!player.hasLineOfSight((Entity)p)) {
                    return false;
                }
                return RescueMessage.isLookingTowards((Player)player, (Entity)p);
            });
            float minDist = Float.MAX_VALUE;
            Player target = null;
            for (Player candidate : candidates) {
                float dist = candidate.distanceTo((Entity)player);
                if (!(dist < minDist)) continue;
                target = candidate;
                minDist = dist;
            }
            if (target != null) {
                HardcoreRevivalManager.startRescue((Player)player, target);
            }
        } else {
            HardcoreRevivalManager.abortRescue((Player)player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

