/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.api.PlayerKnockedOutEvent;
import net.blay09.mods.hardcorerevival.api.PlayerRescuedEvent;
import net.blay09.mods.hardcorerevival.api.PlayerRevivedEvent;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfigData;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.mixin.ServerPlayerAccessor;
import net.blay09.mods.hardcorerevival.network.RevivalProgressMessage;
import net.blay09.mods.hardcorerevival.network.RevivalSuccessMessage;
import net.blay09.mods.hardcorerevival.stats.ModStats;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class HardcoreRevivalManager {
    public static final ResourceKey<DamageType> NOT_RESCUED_IN_TIME = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hardcorerevival", (String)"not_rescued_in_time"));

    public static void knockout(Player player, DamageSource source) {
        MinecraftServer server;
        boolean isConsecutiveKnockout;
        if (PlayerHardcoreRevivalManager.isKnockedOut(player)) {
            return;
        }
        player.stopUsingItem();
        player.stopRiding();
        player.removeEffect(MobEffects.REGENERATION);
        PlayerHardcoreRevivalManager.setKnockedOut(player, true);
        PlayerHardcoreRevivalManager.setKnockoutTicksPassed(player, 0);
        PlayerHardcoreRevivalManager.setLastKnockoutAt(player, System.currentTimeMillis());
        player.awardStat(ModStats.knockouts);
        long lastRescuedAt = PlayerHardcoreRevivalManager.getLastRescuedAt(player);
        int consecutiveThresholdSeconds = HardcoreRevivalConfig.getActive().consecutiveKnockoutThresholdSeconds;
        long secondsSinceLastRescue = (System.currentTimeMillis() - lastRescuedAt) / 1000L;
        boolean bl = isConsecutiveKnockout = consecutiveThresholdSeconds > 0 && lastRescuedAt > 0L && secondsSinceLastRescue <= (long)consecutiveThresholdSeconds;
        if (isConsecutiveKnockout) {
            if (HardcoreRevivalConfig.getActive().resumeTimerOnConsecutiveKnockout) {
                PlayerHardcoreRevivalManager.setKnockoutTicksPassed(player, PlayerHardcoreRevivalManager.getLastKnockoutTicksPassed(player));
            }
            float multiplyTimerOnConsecutiveKnockout = HardcoreRevivalConfig.getActive().multiplyTimerOnConsecutiveKnockout;
            int maxTicksUntilDeath = HardcoreRevivalConfig.getActive().secondsUntilDeath * 20;
            int ticksLeft = maxTicksUntilDeath - PlayerHardcoreRevivalManager.getKnockoutTicksPassed(player);
            int newTicksLeft = (int)((float)ticksLeft * multiplyTimerOnConsecutiveKnockout);
            PlayerHardcoreRevivalManager.setKnockoutTicksPassed(player, maxTicksUntilDeath - newTicksLeft);
        }
        Balm.getEvents().fireEvent((Object)new PlayerKnockedOutEvent(player, source));
        if (player.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && (server = player.getServer()) != null) {
            PlayerTeam team = player.getTeam();
            if (team != null && team.getDeathMessageVisibility() != Team.Visibility.ALWAYS) {
                if (team.getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                    server.getPlayerList().broadcastSystemToTeam(player, player.getCombatTracker().getDeathMessage());
                } else if (team.getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                    server.getPlayerList().broadcastSystemToAllExceptTeam(player, player.getCombatTracker().getDeathMessage());
                }
            } else {
                server.getPlayerList().broadcastSystemMessage(player.getCombatTracker().getDeathMessage(), false);
            }
        }
        HardcoreRevivalManager.updateKnockoutEffects(player);
    }

    public static void wakeup(Player player) {
        HardcoreRevivalManager.wakeup(player, true);
    }

    public static void wakeup(Player player, boolean applyEffects) {
        PlayerHardcoreRevivalManager.setLastRescuedAt(player, System.currentTimeMillis());
        PlayerHardcoreRevivalManager.setLastKnockoutTicksPassed(player, PlayerHardcoreRevivalManager.getKnockoutTicksPassed(player));
        HardcoreRevivalManager.reset(player);
        if (applyEffects) {
            HardcoreRevivalConfigData config = HardcoreRevivalConfig.getActive();
            player.setHealth((float)config.rescueRespawnHealth);
            player.getFoodData().setFoodLevel(config.rescueRespawnFoodLevel);
            for (String effectString : config.rescueRespawnEffects) {
                String[] parts = effectString.split("\\|");
                ResourceLocation registryName = ResourceLocation.tryParse((String)parts[0]);
                if (registryName != null) {
                    Optional holder = BuiltInRegistries.MOB_EFFECT.getHolder(registryName);
                    if (holder.isPresent()) {
                        int duration = HardcoreRevivalManager.tryParseInt(parts.length >= 2 ? parts[1] : null, 600);
                        int amplifier = HardcoreRevivalManager.tryParseInt(parts.length >= 3 ? parts[2] : null, 0);
                        player.addEffect(new MobEffectInstance((Holder)holder.get(), duration, amplifier));
                        continue;
                    }
                    HardcoreRevival.logger.info("Invalid rescue potion effect '{}'", (Object)parts[0]);
                    continue;
                }
                HardcoreRevival.logger.info("Invalid rescue potion effect '{}'", (Object)parts[0]);
            }
        }
        Balm.getEvents().fireEvent((Object)new PlayerRevivedEvent(player));
    }

    private static int tryParseInt(@Nullable String text, int defaultVal) {
        if (text != null) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static void finishRescue(Player player) {
        MinecraftServer server;
        Player rescueTarget = PlayerHardcoreRevivalManager.getRescueTarget(player);
        if (rescueTarget != null && (server = rescueTarget.getServer()) != null) {
            HardcoreRevivalManager.wakeup(rescueTarget);
            Balm.getNetworking().sendTo(player, (CustomPacketPayload)new RevivalProgressMessage(rescueTarget.getId(), -1.0f));
            Balm.getNetworking().sendTo(rescueTarget, (CustomPacketPayload)new RevivalSuccessMessage(rescueTarget.getId()));
            Balm.getNetworking().sendToTracking((Entity)rescueTarget, (CustomPacketPayload)new RevivalSuccessMessage(rescueTarget.getId()));
            PlayerHardcoreRevivalManager.setRescueTarget(player, null);
            Balm.getEvents().fireEvent((Object)new PlayerRescuedEvent(rescueTarget, player));
        }
        Balm.getHooks().setForcedPose(player, null);
    }

    public static void abortRescue(Player player) {
        Player rescueTarget = PlayerHardcoreRevivalManager.getRescueTarget(player);
        if (rescueTarget != null) {
            PlayerHardcoreRevivalManager.setRescueTime(player, 0);
            PlayerHardcoreRevivalManager.setRescueTarget(player, null);
            Balm.getNetworking().sendTo(player, (CustomPacketPayload)new RevivalProgressMessage(-1, -1.0f));
            KnockoutSyncHandler.sendHardcoreRevivalData(rescueTarget, rescueTarget);
            Balm.getHooks().setForcedPose(player, null);
        }
    }

    public static void notRescuedInTime(Player player) {
        if (player instanceof ServerPlayerAccessor) {
            ServerPlayerAccessor accessor = (ServerPlayerAccessor)player;
            accessor.setSpawnInvulnerableTime(0);
        }
        Registry damageTypes = player.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        DamageSource damageSource = new DamageSource((Holder)damageTypes.getHolderOrThrow(NOT_RESCUED_IN_TIME));
        PlayerHardcoreRevivalManager.setLastKnockoutTicksPassed(player, 0);
        HardcoreRevivalManager.reset(player);
        player.hurt(damageSource, Float.MAX_VALUE);
    }

    public static void reset(Player player) {
        PlayerHardcoreRevivalManager.setKnockedOut(player, false);
        PlayerHardcoreRevivalManager.setKnockoutTicksPassed(player, 0);
        HardcoreRevivalManager.updateKnockoutEffects(player);
    }

    public static void updateKnockoutEffects(Player player) {
        if (HardcoreRevivalConfig.getActive().glowOnKnockout) {
            player.setGlowingTag(PlayerHardcoreRevivalManager.isKnockedOut(player));
        }
        Balm.getHooks().setForcedPose(player, (Pose)(PlayerHardcoreRevivalManager.isKnockedOut(player) ? Pose.FALL_FLYING : null));
        KnockoutSyncHandler.sendHardcoreRevivalDataToWatching(player);
    }

    public static void startRescue(Player player, Player target) {
        PlayerHardcoreRevivalManager.setRescueTarget(player, target);
        PlayerHardcoreRevivalManager.setRescueTime(player, 0);
        Balm.getNetworking().sendTo(player, (CustomPacketPayload)new RevivalProgressMessage(target.getId(), 0.1f));
        KnockoutSyncHandler.sendHardcoreRevivalData(target, target, true);
        Balm.getHooks().setForcedPose(player, Pose.CROUCHING);
    }

    public static boolean isRescuing(Player player) {
        Player rescueTarget = PlayerHardcoreRevivalManager.getRescueTarget(player);
        return rescueTarget != null;
    }

    public static boolean isKnockedOut(Player player) {
        return PlayerHardcoreRevivalManager.isKnockedOut(player);
    }
}

