/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.client.FovUpdateEvent;
import net.blay09.mods.balm.api.event.client.GuiDrawEvent;
import net.blay09.mods.balm.api.event.client.OpenScreenEvent;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.client.GuiHelper;
import net.blay09.mods.hardcorerevival.client.KnockoutScreen;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.network.RescueMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class HardcoreRevivalClient {
    private static boolean wasKnockedOut;
    private static boolean isRescuing;
    private static int targetEntity;
    private static float targetProgress;
    private static boolean beingRescued;

    public static void initialize() {
        Balm.getEvents().onEvent(OpenScreenEvent.class, HardcoreRevivalClient::onOpenScreen);
        Balm.getEvents().onEvent(FovUpdateEvent.class, HardcoreRevivalClient::onFovUpdate);
        Balm.getEvents().onEvent(GuiDrawEvent.Pre.class, HardcoreRevivalClient::onGuiDrawPre);
        Balm.getEvents().onEvent(GuiDrawEvent.Post.class, HardcoreRevivalClient::onGuiDrawPost);
        Balm.getEvents().onTickEvent(TickType.Client, TickPhase.Start, HardcoreRevivalClient::onClientTick);
    }

    private static boolean isKnockedOut() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player != null && PlayerHardcoreRevivalManager.isKnockedOut((Player)player) && player.isAlive();
    }

    public static void onOpenScreen(OpenScreenEvent event) {
        if (HardcoreRevivalClient.isKnockedOut() && event.getScreen() instanceof InventoryScreen) {
            event.setScreen((Screen)new KnockoutScreen());
        }
    }

    public static void onFovUpdate(FovUpdateEvent event) {
        if (HardcoreRevivalClient.isKnockedOut()) {
            event.setFov(Float.valueOf((float)Mth.lerp((double)((Double)Minecraft.getInstance().options.fovEffectScale().get()), (double)1.0, (double)0.5)));
        }
    }

    public static void onGuiDrawPre(GuiDrawEvent.Pre event) {
        if (event.getElement() == GuiDrawEvent.Element.HEALTH && HardcoreRevivalClient.isKnockedOut()) {
            int knockoutTicksPassed = PlayerHardcoreRevivalManager.getKnockoutTicksPassed((Player)Minecraft.getInstance().player);
            float redness = (float)Math.sin((float)knockoutTicksPassed / 2.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - redness), (float)(1.0f - redness), (float)1.0f);
        }
    }

    public static void onGuiDrawPost(GuiDrawEvent.Post event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (event.getElement() == GuiDrawEvent.Element.ALL) {
            Minecraft mc = Minecraft.getInstance();
            if (HardcoreRevivalClient.isKnockedOut()) {
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, -300.0f);
                GuiHelper.drawGradientRectW(guiGraphics, 0, 0, mc.getWindow().getWidth(), mc.getWindow().getHeight(), 0x60500000, -1862336512);
                poseStack.popPose();
                if (mc.screen == null || mc.screen instanceof ChatScreen) {
                    int width = event.getWindow().getGuiScaledWidth();
                    int height = event.getWindow().getGuiScaledHeight();
                    GuiHelper.renderKnockedOutTitle(guiGraphics, width);
                    GuiHelper.renderDeathTimer(guiGraphics, width, height, beingRescued);
                    if (HardcoreRevivalConfig.getActive().allowAcceptingFate) {
                        Component openDeathScreenKey = mc.options.keyInventory.getTranslatedKeyMessage();
                        MutableComponent openDeathScreenText = Component.translatable((String)"gui.hardcorerevival.open_death_screen", (Object[])new Object[]{openDeathScreenKey});
                        guiGraphics.drawCenteredString(mc.font, (Component)openDeathScreenText, width / 2, height / 2 + 25, -1);
                    }
                }
            } else {
                Player pointedPlayer;
                Entity pointedEntity;
                Entity entity;
                if (targetEntity != -1 && targetProgress > 0.0f && (entity = mc.level.getEntity(targetEntity)) instanceof Player) {
                    MutableComponent textComponent = Component.translatable((String)"gui.hardcorerevival.rescuing", (Object[])new Object[]{entity.getDisplayName()});
                    if (targetProgress >= 0.75f) {
                        textComponent.append(" ...");
                    } else if (targetProgress >= 0.5f) {
                        textComponent.append(" ..");
                    } else if (targetProgress >= 0.25f) {
                        textComponent.append(" .");
                    }
                    guiGraphics.drawString(mc.font, (Component)textComponent, mc.getWindow().getGuiScaledWidth() / 2 - mc.font.width((FormattedText)textComponent) / 2, mc.getWindow().getGuiScaledHeight() / 2 + 30, -1, true);
                }
                if (!PlayerHardcoreRevivalManager.isKnockedOut((Player)mc.player) && mc.player != null && !mc.player.isSpectator() && mc.player.isAlive() && !isRescuing && (pointedEntity = Minecraft.getInstance().crosshairPickEntity) instanceof Player && PlayerHardcoreRevivalManager.isKnockedOut(pointedPlayer = (Player)pointedEntity) && (double)mc.player.distanceTo(pointedEntity) <= HardcoreRevivalConfig.getActive().rescueDistance) {
                    Component rescueKeyText = mc.options.keyUse.getTranslatedKeyMessage();
                    MutableComponent textComponent = Component.translatable((String)"gui.hardcorerevival.hold_to_rescue", (Object[])new Object[]{rescueKeyText});
                    guiGraphics.drawString(mc.font, (Component)textComponent, mc.getWindow().getGuiScaledWidth() / 2 - mc.font.width((FormattedText)textComponent) / 2, mc.getWindow().getGuiScaledHeight() / 2 + 30, -1, true);
                }
            }
            RenderSystem.enableBlend();
        }
    }

    public static void onClientTick(Minecraft client) {
        if (client.player != null) {
            if (HardcoreRevivalClient.isKnockedOut()) {
                if (!wasKnockedOut) {
                    Balm.getHooks().setForcedPose((Player)client.player, Pose.FALL_FLYING);
                    client.setScreen((Screen)new KnockoutScreen());
                    wasKnockedOut = true;
                }
                PlayerHardcoreRevivalManager.setKnockoutTicksPassed((Player)client.player, PlayerHardcoreRevivalManager.getKnockoutTicksPassed((Player)client.player) + 1);
            } else {
                if (wasKnockedOut) {
                    Balm.getHooks().setForcedPose((Player)client.player, null);
                    wasKnockedOut = false;
                }
                if (client.screen instanceof KnockoutScreen) {
                    client.setScreen(null);
                }
                if (client.options.keyUse.isDown() && !client.player.isSpectator() && client.player.isAlive() && !PlayerHardcoreRevivalManager.isKnockedOut((Player)client.player)) {
                    if (!isRescuing) {
                        Balm.getNetworking().sendToServer((CustomPacketPayload)new RescueMessage(true));
                        isRescuing = true;
                    }
                } else if (isRescuing) {
                    Balm.getNetworking().sendToServer((CustomPacketPayload)new RescueMessage(false));
                    isRescuing = false;
                }
            }
        }
    }

    public static void setRevivalProgress(int entityId, float progress) {
        if (progress < 0.0f) {
            targetEntity = -1;
            targetProgress = 0.0f;
            Balm.getHooks().setForcedPose((Player)Minecraft.getInstance().player, null);
        } else {
            targetEntity = entityId;
            targetProgress = progress;
            Balm.getHooks().setForcedPose((Player)Minecraft.getInstance().player, Pose.CROUCHING);
        }
    }

    public static void setBeingRescued(boolean beingRescued) {
        HardcoreRevivalClient.beingRescued = beingRescued;
    }

    public static boolean isBeingRescued() {
        return beingRescued;
    }

    static {
        targetEntity = -1;
    }
}

