/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LoginLogoutHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(PlayerLoginEvent.class, LoginLogoutHandler::onPlayerLogin);
        Balm.getEvents().onEvent(PlayerLogoutEvent.class, LoginLogoutHandler::onPlayerLogout);
    }

    public static void onPlayerLogin(PlayerLoginEvent event) {
        ServerPlayer player = event.getPlayer();
        if (HardcoreRevivalConfig.getActive().continueTimerWhileOffline && PlayerHardcoreRevivalManager.isKnockedOut((Player)player)) {
            long now = System.currentTimeMillis();
            long then = PlayerHardcoreRevivalManager.getLastLogoutAt((Player)player);
            int millisPassed = (int)Math.max(0L, now - then);
            int secondsPassed = millisPassed / 1000;
            int ticksPassed = secondsPassed * 20;
            PlayerHardcoreRevivalManager.setKnockoutTicksPassed((Player)player, PlayerHardcoreRevivalManager.getKnockoutTicksPassed((Player)player) + ticksPassed);
        }
        HardcoreRevivalManager.updateKnockoutEffects((Player)player);
    }

    public static void onPlayerLogout(PlayerLogoutEvent event) {
        ServerPlayer player = event.getPlayer();
        PlayerHardcoreRevivalManager.setLastLogoutAt((Player)player, System.currentTimeMillis());
    }
}

