/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.michaelmod.network;

import java.util.function.Supplier;
import net.mcreator.michaelmod.MichaelModMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MichaelModModVariables {
    public static double JobApplicantJumpscareRotation = 0.0;
    public static double JobApplicantJumpscareScale = 0.0;
    public static double JobApplicantJumpscareFade = 0.0;
    public static double BossMusicTimerGustavo = 0.0;
    public static double BossMusicTimerRloe = 0.0;
    public static double BossMusicTimerHhgregg = 0.0;
    public static double BossMusicPlayerMainHelpVar = 0.0;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MichaelModMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MichaelModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.DefeatedMegaMimigus = message.data.DefeatedMegaMimigus;
                    variables.DefeatedMindControlMimigus = message.data.DefeatedMindControlMimigus;
                    variables.SpaceMichaelShopSelectedItem = message.data.SpaceMichaelShopSelectedItem;
                    variables.DrinkRootBeerBlockTimer = message.data.DrinkRootBeerBlockTimer;
                    variables.LightningLaserTimer = message.data.LightningLaserTimer;
                    variables.LightningLaserIsActive = message.data.LightningLaserIsActive;
                    variables.DoubleJump_JumpTimes = message.data.DoubleJump_JumpTimes;
                    variables.DoubleJump_AshTime = message.data.DoubleJump_AshTime;
                    variables.DoubleJump_EnchantmentActive1Frame = message.data.DoubleJump_EnchantmentActive1Frame;
                    variables.PartyCardViewingColor = message.data.PartyCardViewingColor;
                    variables.PartyCardViewingAsset = message.data.PartyCardViewingAsset;
                    variables.PartyCardPlaySound = message.data.PartyCardPlaySound;
                    variables.DashToggle = message.data.DashToggle;
                    variables.JobApplicantJumpscare = message.data.JobApplicantJumpscare;
                    variables.LawnMowerBoostJumpType = message.data.LawnMowerBoostJumpType;
                    variables.MechDashActive = message.data.MechDashActive;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean DefeatedMegaMimigus = false;
        public boolean DefeatedMindControlMimigus = false;
        public double SpaceMichaelShopSelectedItem = 0.0;
        public double DrinkRootBeerBlockTimer = 0.0;
        public double LightningLaserTimer = 0.0;
        public boolean LightningLaserIsActive = false;
        public double DoubleJump_JumpTimes = 0.0;
        public double DoubleJump_AshTime = 0.0;
        public boolean DoubleJump_EnchantmentActive1Frame = false;
        public double PartyCardViewingColor = 0.0;
        public double PartyCardViewingAsset = 0.0;
        public boolean PartyCardPlaySound = false;
        public boolean DashToggle = true;
        public boolean JobApplicantJumpscare = false;
        public double LawnMowerBoostJumpType = 0.0;
        public boolean MechDashActive = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MichaelModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("DefeatedMegaMimigus", this.DefeatedMegaMimigus);
            nbt.m_128379_("DefeatedMindControlMimigus", this.DefeatedMindControlMimigus);
            nbt.m_128347_("SpaceMichaelShopSelectedItem", this.SpaceMichaelShopSelectedItem);
            nbt.m_128347_("DrinkRootBeerBlockTimer", this.DrinkRootBeerBlockTimer);
            nbt.m_128347_("LightningLaserTimer", this.LightningLaserTimer);
            nbt.m_128379_("LightningLaserIsActive", this.LightningLaserIsActive);
            nbt.m_128347_("DoubleJump_JumpTimes", this.DoubleJump_JumpTimes);
            nbt.m_128347_("DoubleJump_AshTime", this.DoubleJump_AshTime);
            nbt.m_128379_("DoubleJump_EnchantmentActive1Frame", this.DoubleJump_EnchantmentActive1Frame);
            nbt.m_128347_("PartyCardViewingColor", this.PartyCardViewingColor);
            nbt.m_128347_("PartyCardViewingAsset", this.PartyCardViewingAsset);
            nbt.m_128379_("PartyCardPlaySound", this.PartyCardPlaySound);
            nbt.m_128379_("DashToggle", this.DashToggle);
            nbt.m_128379_("JobApplicantJumpscare", this.JobApplicantJumpscare);
            nbt.m_128347_("LawnMowerBoostJumpType", this.LawnMowerBoostJumpType);
            nbt.m_128379_("MechDashActive", this.MechDashActive);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.DefeatedMegaMimigus = nbt.m_128471_("DefeatedMegaMimigus");
            this.DefeatedMindControlMimigus = nbt.m_128471_("DefeatedMindControlMimigus");
            this.SpaceMichaelShopSelectedItem = nbt.m_128459_("SpaceMichaelShopSelectedItem");
            this.DrinkRootBeerBlockTimer = nbt.m_128459_("DrinkRootBeerBlockTimer");
            this.LightningLaserTimer = nbt.m_128459_("LightningLaserTimer");
            this.LightningLaserIsActive = nbt.m_128471_("LightningLaserIsActive");
            this.DoubleJump_JumpTimes = nbt.m_128459_("DoubleJump_JumpTimes");
            this.DoubleJump_AshTime = nbt.m_128459_("DoubleJump_AshTime");
            this.DoubleJump_EnchantmentActive1Frame = nbt.m_128471_("DoubleJump_EnchantmentActive1Frame");
            this.PartyCardViewingColor = nbt.m_128459_("PartyCardViewingColor");
            this.PartyCardViewingAsset = nbt.m_128459_("PartyCardViewingAsset");
            this.PartyCardPlaySound = nbt.m_128471_("PartyCardPlaySound");
            this.DashToggle = nbt.m_128471_("DashToggle");
            this.JobApplicantJumpscare = nbt.m_128471_("JobApplicantJumpscare");
            this.LawnMowerBoostJumpType = nbt.m_128459_("LawnMowerBoostJumpType");
            this.MechDashActive = nbt.m_128471_("MechDashActive");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("michael_mod", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "michael_mod_mapvars";
        public boolean DoJoinMessage = true;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.DoJoinMessage = nbt.m_128471_("DoJoinMessage");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("DoJoinMessage", this.DoJoinMessage);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MichaelModMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "michael_mod_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MichaelModMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.DefeatedMegaMimigus = original.DefeatedMegaMimigus;
            clone.DefeatedMindControlMimigus = original.DefeatedMindControlMimigus;
            clone.DoubleJump_JumpTimes = original.DoubleJump_JumpTimes;
            clone.DoubleJump_AshTime = original.DoubleJump_AshTime;
            clone.DoubleJump_EnchantmentActive1Frame = original.DoubleJump_EnchantmentActive1Frame;
            clone.PartyCardPlaySound = original.PartyCardPlaySound;
            clone.DashToggle = original.DashToggle;
            if (!event.isWasDeath()) {
                clone.SpaceMichaelShopSelectedItem = original.SpaceMichaelShopSelectedItem;
                clone.DrinkRootBeerBlockTimer = original.DrinkRootBeerBlockTimer;
                clone.LightningLaserTimer = original.LightningLaserTimer;
                clone.LightningLaserIsActive = original.LightningLaserIsActive;
                clone.PartyCardViewingColor = original.PartyCardViewingColor;
                clone.PartyCardViewingAsset = original.PartyCardViewingAsset;
                clone.JobApplicantJumpscare = original.JobApplicantJumpscare;
                clone.LawnMowerBoostJumpType = original.LawnMowerBoostJumpType;
                clone.MechDashActive = original.MechDashActive;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MichaelModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MichaelModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MichaelModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

