/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.uebliche.hub.Hub;
import net.uebliche.hub.commands.DebugCommand;
import net.uebliche.hub.config.Lobby;
import net.uebliche.hub.data.PingResult;
import net.uebliche.hub.utils.CommandUtils;
import net.uebliche.hub.utils.ConfigUtils;
import net.uebliche.hub.utils.LobbyUtils;
import net.uebliche.hub.utils.MessageUtils;
import net.uebliche.hub.utils.PlayerUtils;
import net.uebliche.hub.utils.Utils;

public class HubCommand {
    private final Hub hub;
    protected ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();

    public HubCommand(Hub hub) {
        this.hub = hub;
    }

    public void create() {
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)configUtils.config().baseHubCommand).requires(commandSource -> {
            Player player;
            return commandSource instanceof ConsoleCommandSource || commandSource instanceof Player && (player = (Player)commandSource).getCurrentServer().isPresent() && !configUtils.config().hideHubCommandOnLobby.matcher(((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName()).matches();
        })).executes(commandContext -> {
            messageUtils.sendDebugMessage((Audience)commandContext.getSource(), "\ud83e\udd16 Executing Hub Command!");
            return this.execute((CommandContext<CommandSource>)commandContext);
        })).then(new DebugCommand(this.hub).create());
        configUtils.config().lobbies.forEach(lobby -> lobby.commands.forEach((s, command) -> {
            if (command.subcommand) {
                base.then(((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)s).requires(source -> {
                    if (!(source instanceof Player)) return false;
                    Player player = (Player)source;
                    if (lobby.permission.isBlank()) return true;
                    if (!player.hasPermission(lobby.permission)) return false;
                    return true;
                })).executes(commandContext -> {
                    messageUtils.sendDebugMessage((Audience)commandContext.getSource(), "\ud83e\udd16 Executing Hub Command for Lobby: " + s + "!");
                    return this.execute((CommandContext<CommandSource>)commandContext, (Lobby)lobby);
                }));
            }
            if (command.standalone) {
                Utils.util(CommandUtils.class).registerCommand(this.hub.server().getCommandManager().metaBuilder(s).plugin((Object)this.hub).build(), new BrigadierCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)s).requires(source -> {
                    Player player;
                    return source instanceof Player && ((player = (Player)source).hasPermission(lobby.permission) || lobby.permission.isBlank());
                })).executes(commandContext -> {
                    messageUtils.broadcastDebugMessage("\ud83e\udd16 " + ((CommandSource)commandContext.getSource()).toString() + " -> Executing Hub Command for Lobby: " + s + "!");
                    return this.execute((CommandContext<CommandSource>)commandContext, (Lobby)lobby);
                })));
            }
        }));
        this.hub.server().getCommandManager().register(this.hub.server().getCommandManager().metaBuilder(configUtils.config().baseHubCommand).aliases(configUtils.config().aliases.toArray(new String[0])).plugin((Object)this.hub).build(), (Command)new BrigadierCommand(base.build()));
    }

    private int execute(CommandContext<CommandSource> commandContext) {
        Player player;
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        messageUtils.broadcastDebugMessage("\ud83e\udd16 " + ((CommandSource)commandContext.getSource()).toString() + " ->  Executing Hub Command");
        Player player2 = player = commandContext.getSource() instanceof Player ? (Player)commandContext.getSource() : null;
        if (player == null) {
            ((CommandSource)commandContext.getSource()).sendMessage(messageUtils.toMessage(configUtils.config().systemMessages.playersOnlyCommandMessage, new Object[0]));
            return 0;
        }
        if (!player.getCurrentServer().isPresent()) {
            messageUtils.sendMessage(player, "<red>\u274c User is on no Server!", new Object[0]);
            return 0;
        }
        LobbyUtils lobbyUtils = Utils.util(LobbyUtils.class);
        Optional<PingResult> pingResult = lobbyUtils.findBest(player);
        if (pingResult.isEmpty()) {
            messageUtils.sendMessage(player, configUtils.config().systemMessages.noLobbyFoundMessage, player);
            messageUtils.sendDebugMessage((Audience)player, "<red>\u274c No Server found!");
            return 0;
        }
        pingResult.get().connect();
        return 1;
    }

    private int execute(CommandContext<CommandSource> commandContext, Lobby lobby) {
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        Player player = commandContext.getSource() instanceof Player ? (Player)commandContext.getSource() : null;
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        messageUtils.broadcastDebugMessage("\ud83e\udd16 " + ((CommandSource)commandContext.getSource()).toString() + " ->  Executing Hub Command for Lobby: " + lobby.name + "!");
        if (player == null) {
            ((CommandSource)commandContext.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)configUtils.config().systemMessages.playersOnlyCommandMessage));
            return 1;
        }
        ServerConnection currentServer = player.getCurrentServer().orElse(null);
        if (currentServer == null) {
            messageUtils.sendMessage(player, "<red>\u274c User is on no Server!", new Object[0]);
            return 1;
        }
        if (lobby.filter.matcher(currentServer.getServerInfo().getName()).matches()) {
            messageUtils.sendMessage(player, lobby.messages().alreadyConnectedMessage == null ? configUtils.config().messages.alreadyConnectedMessage : lobby.messages().alreadyConnectedMessage, currentServer.getServer(), lobby);
            return 1;
        }
        this.executor.execute(() -> {
            ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
            AtomicBoolean isConnected = new AtomicBoolean(false);
            this.hub.server().getAllServers().stream().filter(registeredServer -> lobby.filter.matcher(registeredServer.getServerInfo().getName()).matches()).forEach(registeredServer -> CompletableFuture.runAsync(() -> registeredServer.ping().thenAccept(result -> {
                if (isConnected.get()) {
                    return;
                }
                isConnected.set(true);
                Utils.util(PlayerUtils.class).connect(player, (RegisteredServer)registeredServer, lobby);
                executor.shutdown();
            }), executor));
        });
        return 1;
    }
}

