/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub.utils;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.uebliche.hub.Hub;
import net.uebliche.hub.commands.DebugCommand;
import net.uebliche.hub.commands.HubCommand;
import net.uebliche.hub.utils.ConfigUtils;
import net.uebliche.hub.utils.MessageUtils;
import net.uebliche.hub.utils.Utils;

public class CommandUtils
extends Utils<CommandUtils> {
    private final ConcurrentLinkedDeque<CommandMeta> commands = new ConcurrentLinkedDeque();

    public CommandUtils(Hub hub) {
        super(hub);
        Utils.util(ConfigUtils.class).onReload(() -> {
            this.unregisterCommands();
            this.registerCommands();
        });
        if (Utils.util(ConfigUtils.class).config() == null) {
            this.registerDebugCommand();
            this.logger.debug("Debug command registered (/hub debug reload to reload the config)");
        }
        this.registerCommands();
    }

    public void unregisterCommands() {
        this.commands.forEach(this::unregister);
    }

    private void unregister(CommandMeta meta) {
        this.hub.server().getCommandManager().unregister(meta);
        this.commands.remove(meta);
    }

    public void registerCommand(CommandMeta meta, BrigadierCommand command) {
        this.commands.add(meta);
        this.hub.server().getCommandManager().register(meta, (Command)command);
    }

    private void registerCommands() {
        new HubCommand(this.hub).create();
    }

    private void registerDebugCommand() {
        this.logger.debug("Debug command got registered");
        this.registerCommand(this.hub.server().getCommandManager().metaBuilder("hub").plugin((Object)this.hub).build(), new BrigadierCommand(((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"hub").executes(commandContext -> {
            Object patt0$temp = commandContext.getSource();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSource)commandContext.getSource()).sendMessage(Utils.util(MessageUtils.class).toMessage(Utils.util(ConfigUtils.class).config().systemMessages.playersOnlyCommandMessage, new Object[0]));
            } else {
                Player player = (Player)patt0$temp;
                this.hub.server().getConfiguration().getAttemptConnectionOrder().stream().findAny().ifPresent(attemptConnectionOrder -> player.createConnectionRequest((RegisteredServer)this.hub.server().getServer(attemptConnectionOrder).get()).connect().thenAccept(connection -> {}));
            }
            return 1;
        })).then(new DebugCommand(this.hub).create())).build()));
    }
}

