/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub.utils;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.uebliche.hub.Hub;
import net.uebliche.hub.config.Lobby;
import net.uebliche.hub.data.PingResult;
import net.uebliche.hub.utils.ConfigUtils;
import net.uebliche.hub.utils.MessageUtils;
import net.uebliche.hub.utils.PlayerUtils;
import net.uebliche.hub.utils.Utils;

public class LobbyUtils
extends Utils<LobbyUtils> {
    private final ExecutorService pingExecutor = Executors.newVirtualThreadPerTaskExecutor();
    private final Map<String, CachedPing> cachedServers = new ConcurrentHashMap<String, CachedPing>();
    private final AtomicBoolean refreshing = new AtomicBoolean(false);
    private ScheduledTask refreshTask;

    public LobbyUtils(Hub hub) {
        super(hub);
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        if (configUtils != null) {
            configUtils.onReload(this::reschedule);
        }
        this.reschedule();
    }

    public Optional<PingResult> findBest(Player player) {
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        PlayerUtils playerUtils = Utils.util(PlayerUtils.class);
        if (configUtils == null || configUtils.config() == null) {
            return Optional.empty();
        }
        messageUtils.sendDebugMessage((Audience)player, "\ud83d\udd0d Searching for Best Lobby Server...");
        List<Lobby> accessibleLobbies = configUtils.config().lobbies.stream().sorted(Comparator.comparingInt(Lobby::priority).reversed()).filter(lobby -> playerUtils.permissionCheck(player, (Lobby)lobby)).toList();
        if (accessibleLobbies.isEmpty()) {
            messageUtils.sendDebugMessage((Audience)player, "<yellow>\u26a0\ufe0f No eligible lobbies available for this player.");
            return Optional.empty();
        }
        PingResult best = null;
        CachedPing bestSource = null;
        HashSet<String> noServerAnnouncements = new HashSet<String>();
        boolean attemptedRefresh = false;
        for (Lobby lobby2 : accessibleLobbies) {
            List<CachedPing> matching = this.cachedServers.values().stream().filter(status -> lobby.filter.matcher(status.server().getServerInfo().getName()).matches()).toList();
            if (matching.isEmpty() && !attemptedRefresh) {
                attemptedRefresh = true;
                messageUtils.sendDebugMessage((Audience)player, "<yellow>\u26a0\ufe0f Cache empty for lobby " + lobby2.name + "; refreshing now...");
                try {
                    this.refreshNow().join();
                }
                catch (Exception exception) {
                    messageUtils.sendDebugMessage((Audience)player, "<red>\u274c Failed to refresh lobby cache: " + exception.getClass().getSimpleName() + (String)(exception.getMessage() != null ? " - " + exception.getMessage() : "") + ".");
                }
                matching = this.cachedServers.values().stream().filter(status -> lobby.filter.matcher(status.server().getServerInfo().getName()).matches()).toList();
            }
            if (matching.isEmpty()) {
                if (!noServerAnnouncements.add(lobby2.name)) continue;
                messageUtils.sendDebugMessage((Audience)player, "<yellow>\u26a0\ufe0f No cached servers available for " + lobby2.name + ".");
                continue;
            }
            CachedPing lobbyBest = matching.stream().min(Comparator.comparingDouble(this::score)).orElse(null);
            if (lobbyBest == null) continue;
            best = new PingResult(player, lobbyBest.latency(), lobbyBest.server(), lobbyBest.players(), lobby2);
            bestSource = lobbyBest;
            break;
        }
        if (best == null) {
            messageUtils.sendDebugMessage((Audience)player, "<red>\u274c No cached lobby data available.");
            return Optional.empty();
        }
        long age = Math.max(System.currentTimeMillis() - bestSource.updatedAt(), 0L);
        String serverName = best.server().getServerInfo().getName();
        int online = best.players().getOnline();
        int max = best.players().getMax();
        long latency = best.latency();
        messageUtils.sendDebugMessage((Audience)player, "<yellow>\ud83e\udded Selected <gold>" + serverName + "</gold> <gray>(" + online + "<dark_gray>/" + max + " players, latency " + latency + "ms, cached " + age + "ms ago)</gray>");
        return Optional.of(best);
    }

    private double score(CachedPing cached) {
        double usage = cached.usage();
        return Math.abs(usage + 0.2 - 0.5);
    }

    private void reschedule() {
        this.cancelRefreshTask();
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        if (configUtils == null || configUtils.config() == null) {
            return;
        }
        int refreshTicks = Math.max(configUtils.config().finder.refreshIntervalInTicks, 1);
        Duration interval = Duration.ofMillis((long)refreshTicks * 50L);
        this.refreshTask = this.hub.server().getScheduler().buildTask((Object)this.hub, this::refreshAll).delay(Duration.ZERO).repeat(interval).schedule();
        this.refreshAll();
    }

    public CompletableFuture<Void> refreshNow() {
        return CompletableFuture.runAsync(this::refreshAll, this.pingExecutor);
    }

    public List<CachedResult> getCachedResults(Player player, Lobby lobby) {
        long now = System.currentTimeMillis();
        return this.cachedServers.values().stream().filter(status -> lobby.filter.matcher(status.server().getServerInfo().getName()).matches()).sorted(Comparator.comparingDouble(this::score)).map(cached -> new CachedResult(new PingResult(player, cached.latency(), cached.server(), cached.players(), lobby), Math.max(now - cached.updatedAt(), 0L))).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAll() {
        if (!this.refreshing.compareAndSet(false, true)) {
            return;
        }
        try {
            ConfigUtils configUtils = Utils.util(ConfigUtils.class);
            if (configUtils == null || configUtils.config() == null) {
                return;
            }
            int timeoutMillis = Math.max(configUtils.config().finder.maxDuration, configUtils.config().finder.startDuration);
            timeoutMillis = Math.max(timeoutMillis, 50);
            Duration timeout = Duration.ofMillis(timeoutMillis);
            List<Lobby> lobbies = configUtils.config().lobbies;
            List<RegisteredServer> servers = this.hub.server().getAllServers().stream().filter(server -> this.matchesAnyLobby((RegisteredServer)server, lobbies)).toList();
            if (servers.isEmpty()) {
                this.cachedServers.clear();
                return;
            }
            Set activeNames = servers.stream().map(server -> server.getServerInfo().getName()).collect(Collectors.toSet());
            this.cachedServers.keySet().removeIf(name -> !activeNames.contains(name));
            Map<String, CompletableFuture> futures = servers.stream().collect(Collectors.toMap(server -> server.getServerInfo().getName(), server -> CompletableFuture.supplyAsync(() -> this.pingServer((RegisteredServer)server, timeout), this.pingExecutor)));
            CompletableFuture.allOf(futures.values().toArray(new CompletableFuture[0])).join();
            futures.forEach((name, future) -> {
                CachedPing result = future.getNow(null);
                if (result != null) {
                    this.cachedServers.put((String)name, result);
                } else {
                    this.cachedServers.remove(name);
                }
            });
        }
        finally {
            this.refreshing.set(false);
        }
    }

    private boolean matchesAnyLobby(RegisteredServer server, List<Lobby> lobbies) {
        String serverName = server.getServerInfo().getName();
        return lobbies.stream().anyMatch(lobby -> lobby.filter.matcher(serverName).matches());
    }

    private CachedPing pingServer(RegisteredServer server, Duration timeout) {
        long start = System.currentTimeMillis();
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        if (messageUtils != null) {
            messageUtils.broadcastDebugMessage("<gray>\ud83d\udce1 Pinging " + server.getServerInfo().getName() + " (timeout " + timeout.toMillis() + "ms)...</gray>");
        }
        try {
            ServerPing ping = (ServerPing)server.ping().orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).join();
            if (ping == null) {
                if (messageUtils != null) {
                    messageUtils.broadcastDebugMessage("<red>\ud83d\udce1 Ping to " + server.getServerInfo().getName() + " returned no data.</red>");
                }
                return null;
            }
            ServerPing.Players players = ping.getPlayers().orElseGet(() -> new ServerPing.Players(0, 1, List.of()));
            long now = System.currentTimeMillis();
            if (messageUtils != null) {
                messageUtils.broadcastDebugMessage("<green>\ud83d\udce1 Ping success for " + server.getServerInfo().getName() + ": " + players.getOnline() + "/" + players.getMax() + " players, latency " + (now - start) + "ms.</green>");
            }
            return new CachedPing(server, players, now - start, now);
        }
        catch (Exception exception) {
            if (messageUtils != null) {
                messageUtils.broadcastDebugMessage("<red>\ud83d\udce1 Ping failed for " + server.getServerInfo().getName() + ": " + exception.getClass().getSimpleName() + (String)(exception.getMessage() != null ? " - " + exception.getMessage() : "") + "</red>");
            }
            return null;
        }
    }

    private void cancelRefreshTask() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
            this.refreshTask = null;
        }
    }

    @Override
    public void close() {
        this.cancelRefreshTask();
        this.refreshing.set(false);
        this.cachedServers.clear();
        this.pingExecutor.shutdownNow();
    }

    private record CachedPing(RegisteredServer server, ServerPing.Players players, long latency, long updatedAt) {
        double usage() {
            int maxPlayers = Math.max(this.players.getMax(), 1);
            return (double)this.players.getOnline() / (double)maxPlayers;
        }
    }

    public record CachedResult(PingResult result, long ageMillis) {
    }
}

