/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub.utils;

import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.uebliche.hub.Hub;
import net.uebliche.hub.config.Config;
import net.uebliche.hub.config.Lobby;
import net.uebliche.hub.utils.ConfigUtils;
import net.uebliche.hub.utils.PlayerUtils;
import net.uebliche.hub.utils.Utils;

public class MessageUtils
extends Utils<MessageUtils> {
    public MessageUtils(Hub hub) {
        super(hub);
    }

    public Component toMessage(String message, Object ... objects) {
        return MiniMessage.miniMessage().deserialize(message, (TagResolver[])this.placeholders(objects).toArray(new TagResolver.Single[0]));
    }

    public void sendMessage(Player player, String message, Object ... objects) {
        if (message.isBlank()) {
            return;
        }
        player.sendMessage(this.toMessage(message, objects));
    }

    public List<TagResolver.Single> placeholders(Object ... objects) {
        ArrayList<TagResolver.Single> placeholders = new ArrayList<TagResolver.Single>();
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        Config.Placeholder placeholder = configUtils.config().placeholder;
        for (Object object : objects) {
            if (object instanceof TagResolver.Single) {
                TagResolver.Single single = (TagResolver.Single)object;
                placeholders.add(single);
                continue;
            }
            if (object instanceof RegisteredServer) {
                RegisteredServer registeredServer = (RegisteredServer)object;
                if (placeholder.server.enabled() || placeholder.serverHost.enabled() || placeholder.serverPort.enabled() || placeholder.serverPlayerCount.enabled() || placeholder.serverPlayerPerPlayerUsername.enabled() || placeholder.serverPlayerPerPlayerUuid.enabled()) {
                    ServerInfo serverInfo = registeredServer.getServerInfo();
                    if (placeholder.server.enabled()) {
                        placeholders.add(Placeholder.unparsed((String)placeholder.server.key(), (String)serverInfo.getName()));
                    }
                    if (placeholder.serverHost.enabled()) {
                        placeholders.add(Placeholder.unparsed((String)placeholder.serverHost.key(), (String)serverInfo.getAddress().getHostString()));
                    }
                    if (placeholder.serverPort.enabled()) {
                        placeholders.add(Placeholder.unparsed((String)placeholder.serverPort.key(), (String)String.valueOf(serverInfo.getAddress().getPort())));
                    }
                    if (placeholder.serverPlayerCount.enabled()) {
                        int playerCount = registeredServer.getPlayersConnected().size();
                        placeholders.add(Placeholder.unparsed((String)placeholder.serverPlayerCount.key(), (String)String.valueOf(playerCount)));
                        this.broadcastDebugMessage("<gray>\ud83d\udc65 Server " + serverInfo.getName() + " currently tracks " + playerCount + " players.</gray>");
                    }
                    if (placeholder.serverPlayerPerPlayerUsername.enabled() || placeholder.serverPlayerPerPlayerUuid.enabled()) {
                        AtomicInteger i = new AtomicInteger(0);
                        registeredServer.getPlayersConnected().forEach(player -> {
                            int id = i.getAndIncrement();
                            if (placeholder.serverPlayerPerPlayerUsername.enabled()) {
                                placeholders.add(Placeholder.unparsed((String)placeholder.serverPlayerPerPlayerUsername.key().replaceFirst(placeholder.serverPlayerPerPlayerUsername.placeholder(), String.valueOf(id)), (String)player.getUsername()));
                            }
                            if (placeholder.serverPlayerPerPlayerUuid.enabled()) {
                                placeholders.add(Placeholder.unparsed((String)placeholder.serverPlayerPerPlayerUuid.key().replaceFirst(placeholder.serverPlayerPerPlayerUuid.placeholder(), String.valueOf(id)), (String)player.getUniqueId().toString()));
                            }
                        });
                    }
                }
            }
            if (object instanceof Lobby) {
                Lobby lobby = (Lobby)object;
                if (placeholder.lobby.enabled()) {
                    placeholders.add(Placeholder.unparsed((String)placeholder.lobby.key(), (String)lobby.name));
                }
                if (placeholder.lobbyFilter.enabled()) {
                    placeholders.add(Placeholder.unparsed((String)placeholder.lobbyFilter.key(), (String)lobby.filter.toString()));
                }
                if (placeholder.lobbyPermission.enabled()) {
                    placeholders.add(Placeholder.unparsed((String)placeholder.lobbyPermission.key(), (String)lobby.permission));
                }
                if (placeholder.lobbyPriority.enabled()) {
                    placeholders.add(Placeholder.unparsed((String)placeholder.lobbyPriority.key(), (String)String.valueOf(lobby.priority)));
                }
                if (placeholder.lobbyCommandPerCommandStandalone.enabled() || placeholder.lobbyCommandPerCommandSubcommand.enabled() || placeholder.lobbyCommandPerCommandHideOn.enabled()) {
                    lobby.commands.forEach((s, command) -> {
                        if (placeholder.lobbyCommandPerCommandStandalone.enabled()) {
                            placeholders.add(Placeholder.unparsed((String)placeholder.lobbyCommandPerCommandStandalone.key().replaceFirst(placeholder.lobbyCommandPerCommandStandalone.placeholder(), (String)s), (String)(command.standalone ? "true" : "false")));
                        }
                        if (placeholder.lobbyCommandPerCommandSubcommand.enabled()) {
                            placeholders.add(Placeholder.unparsed((String)placeholder.lobbyCommandPerCommandSubcommand.key().replaceFirst(placeholder.lobbyCommandPerCommandSubcommand.placeholder(), (String)s), (String)(command.subcommand ? "true" : "false")));
                        }
                        if (placeholder.lobbyCommandPerCommandHideOn.enabled()) {
                            placeholders.add(Placeholder.unparsed((String)placeholder.lobbyCommandPerCommandHideOn.key().replaceFirst(placeholder.lobbyCommandPerCommandHideOn.placeholder(), (String)s), (String)command.hideOn().toString()));
                        }
                    });
                }
                if (placeholder.lobbyAutojoin.enabled()) {
                    placeholders.add(Placeholder.unparsed((String)placeholder.lobbyAutojoin.key(), (String)String.valueOf(lobby.autojoin)));
                }
            }
            if (!(object instanceof Player)) continue;
            Player player2 = (Player)object;
            if (placeholder.player.enabled()) {
                placeholders.add(Placeholder.unparsed((String)placeholder.player.key(), (String)player2.getUsername()));
            }
            if (!placeholder.playerUuid.enabled()) continue;
            placeholders.add(Placeholder.unparsed((String)placeholder.playerUuid.key(), (String)player2.getUniqueId().toString()));
        }
        return placeholders;
    }

    public void sendDebugMessage(Audience recipient, String message) {
        this.sendDebugMessage(recipient, MiniMessage.miniMessage().deserialize((Object)message));
        this.broadcastDebugMessage(Component.text((String)recipient.toString()).append(MiniMessage.miniMessage().deserialize((Object)message)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendDebugMessage(Audience recipient, Component message) {
        block5: {
            block4: {
                if (!this.isDebugEnabled()) {
                    return;
                }
                if (!(recipient instanceof Player)) break block4;
                Player player = (Player)recipient;
                if (Utils.util(PlayerUtils.class).canDebug(player)) break block5;
            }
            if (!(recipient instanceof ConsoleCommandSource)) return;
        }
        boolean bl = true;
        boolean canSend = bl;
        if (!canSend) return;
        recipient.sendMessage(this.toDebugMessage(message));
    }

    public void sendDebugCommandMessage(Audience recipient, String message) {
        this.sendDebugCommandMessage(recipient, MiniMessage.miniMessage().deserialize((Object)message));
    }

    public void sendDebugCommandMessage(Audience recipient, Component message) {
        recipient.sendMessage(this.toDebugMessage(message));
    }

    private Component toDebugMessage(Component message) {
        return ((TextComponent)Component.empty().append(Component.text((String)"[Debug]: ").style(Style.style((StyleBuilderApplicable[])new StyleBuilderApplicable[]{TextDecoration.BOLD, NamedTextColor.YELLOW})))).append(message);
    }

    public void broadcastDebugMessage(String message) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.broadcastDebugMessage(MiniMessage.miniMessage().deserialize((Object)message));
    }

    public void broadcastDebugMessage(Component message) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.hub.server().filterAudience(audience -> {
            if (audience instanceof Player) {
                Player player = (Player)audience;
                if (Utils.util(PlayerUtils.class).canDebug(player)) return true;
            }
            if (!(audience instanceof ConsoleCommandSource)) return false;
            return true;
        }).sendMessage(this.toDebugMessage(message));
    }

    private boolean isDebugEnabled() {
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        return configUtils != null && configUtils.config() != null && configUtils.config().debug.enabled;
    }
}

