/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import net.uebliche.hub.Hub;
import net.uebliche.hub.utils.ConfigUtils;
import net.uebliche.hub.utils.MessageUtils;
import net.uebliche.hub.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateChecker
extends Utils<UpdateChecker> {
    private static final Logger logger = LoggerFactory.getLogger((String)"hub | updatechecker");
    public volatile boolean updateAvailable = false;
    public volatile String latest = "2025.11.27";
    private final HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).build();
    private final AtomicBoolean checking = new AtomicBoolean(false);
    private ScheduledTask task;

    public UpdateChecker(Hub hub) {
        super(hub);
        Utils.util(ConfigUtils.class).onReload(this::reschedule);
        this.reschedule();
    }

    public void reschedule() {
        this.cancelTask();
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        if (configUtils == null || configUtils.config() == null) {
            return;
        }
        net.uebliche.hub.config.UpdateChecker updateConfig = configUtils.config().updateChecker;
        if (!updateConfig.enabled) {
            this.updateAvailable = false;
            this.latest = "2025.11.27";
            return;
        }
        long intervalMinutes = Math.max(updateConfig.checkIntervalInMin == null ? 0 : updateConfig.checkIntervalInMin, 5);
        this.task = this.hub.server().getScheduler().buildTask((Object)this.hub, this::runCheck).delay(Duration.ZERO).repeat(Duration.ofMinutes(intervalMinutes)).schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCheck() {
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        if (configUtils == null || configUtils.config() == null) {
            return;
        }
        net.uebliche.hub.config.UpdateChecker updateConfig = configUtils.config().updateChecker;
        if (!updateConfig.enabled) {
            this.updateAvailable = false;
            this.latest = "2025.11.27";
            this.cancelTask();
            return;
        }
        if (!this.checking.compareAndSet(false, true)) {
            return;
        }
        try {
            String responseBody;
            MessageUtils messageUtils = Utils.util(MessageUtils.class);
            if (messageUtils != null) {
                messageUtils.broadcastDebugMessage("\ud83d\udd04 Checking for Updates...");
            }
            if ((responseBody = this.client.send(HttpRequest.newBuilder().uri(URI.create("https://api.modrinth.com/v2/project/HrTclB8n/version")).header("User-Agent", "HUB 2025.11.27").timeout(Duration.ofSeconds(30L)).GET().build(), HttpResponse.BodyHandlers.ofString()).body()) == null) {
                logger.warn("Unable to check for Updates!");
                return;
            }
            JsonElement body = JsonParser.parseString((String)responseBody);
            if (!body.isJsonArray() || body.getAsJsonArray().isEmpty()) {
                logger.warn("Unexpected response from update API");
                return;
            }
            JsonObject latestVersion = body.getAsJsonArray().get(0).getAsJsonObject();
            String latestVersionString = latestVersion.get("version_number").getAsString();
            int compare = this.compareVersions(latestVersionString, "2025.11.27");
            if (compare > 0) {
                this.latest = latestVersionString;
                logger.info("An update is available! Latest version: {}, you are using: {}", (Object)latestVersionString, (Object)"2025.11.27");
                logger.info("Download it at https://modrinth.com/plugin/hub/version/{}", (Object)latestVersionString);
                this.updateAvailable = true;
            } else if (compare < 0) {
                logger.warn("You are running {} (a newer version of the plugin than released).", (Object)"2025.11.27");
            } else {
                this.updateAvailable = false;
                this.latest = "2025.11.27";
            }
        }
        catch (Exception e) {
            logger.warn("Failed to check for updates", (Throwable)e);
        }
        finally {
            this.checking.set(false);
        }
    }

    private int compareVersions(String latest, String current) {
        try {
            ModuleDescriptor.Version latestVersion = ModuleDescriptor.Version.parse(latest);
            ModuleDescriptor.Version currentVersion = ModuleDescriptor.Version.parse(current);
            return latestVersion.compareTo(currentVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return latest.compareToIgnoreCase(current);
        }
    }

    private void cancelTask() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    @Override
    public void close() {
        this.cancelTask();
        this.checking.set(false);
    }
}

