/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.nio.file.Path;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.uebliche.hub.data.PingResult;
import net.uebliche.hub.utils.CommandUtils;
import net.uebliche.hub.utils.ConfigUtils;
import net.uebliche.hub.utils.LobbyUtils;
import net.uebliche.hub.utils.MessageUtils;
import net.uebliche.hub.utils.PlayerUtils;
import net.uebliche.hub.utils.UpdateChecker;
import net.uebliche.hub.utils.Utils;
import org.slf4j.Logger;
import org.spongepowered.configurate.ConfigurateException;

@Plugin(id="hub", name="HUB", version="2025-10-05", authors={"Freddi"})
public class Hub {
    @Inject
    private final Logger logger;
    private final ProxyServer server;
    private final Path dataDirectory;

    @Inject
    public Hub(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.logger = logger;
        this.server = server;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        new ConfigUtils(this, this.dataDirectory);
        new PlayerUtils(this);
        new MessageUtils(this);
        new LobbyUtils(this);
        try {
            Utils.util(ConfigUtils.class).reload();
            new UpdateChecker(this);
        }
        catch (ConfigurateException e) {
            this.logger.error("Failed to load config!", (Throwable)e);
        }
        new CommandUtils(this);
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        Utils.shutdownAll();
        this.logger.info("Goodbye!");
    }

    @Subscribe
    public void onPlayerChooseInitialServer(PlayerChooseInitialServerEvent event) {
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        messageUtils.sendDebugMessage((Audience)event.getPlayer(), "<gray>PlayerChooseInitialServerEvent triggered (initial=" + event.getInitialServer().map(s -> s.getServerInfo().getName()).orElse("<none>") + ")</gray>");
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        if (configUtils.config().autoSelect.onJoin) {
            LobbyUtils lobbyUtils = Utils.util(LobbyUtils.class);
            Optional<PingResult> selection = lobbyUtils.findBest(event.getPlayer());
            if (selection.isPresent()) {
                event.setInitialServer(selection.get().server());
            } else {
                messageUtils.sendDebugMessage((Audience)event.getPlayer(), "<red>\u274c No lobby could be selected during login.");
                if (event.getInitialServer().isEmpty()) {
                    event.getPlayer().disconnect(messageUtils.toMessage(configUtils.config().systemMessages.noLobbyFoundMessage, event.getPlayer()));
                }
            }
        }
        UpdateChecker updateChecker = Utils.util(UpdateChecker.class);
        if (configUtils.config().updateChecker.enabled && updateChecker.updateAvailable && (configUtils.config().updateChecker.notification.isBlank() || event.getPlayer().hasPermission(configUtils.config().updateChecker.notification))) {
            event.getPlayer().sendMessage(MiniMessage.miniMessage().deserialize(configUtils.config().updateChecker.notification, new TagResolver[]{Placeholder.parsed((String)"current", (String)"2025-10-05"), Placeholder.parsed((String)"latest", (String)updateChecker.latest)}));
        }
    }

    @Subscribe
    public void onKickedFromServer(KickedFromServerEvent event) {
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        messageUtils.sendDebugMessage((Audience)event.getPlayer(), "<gray>KickedFromServerEvent triggered from " + event.getServer().getServerInfo().getName() + " (result=" + String.valueOf(event.getResult()) + ")</gray>");
        if (Utils.util(ConfigUtils.class).config().autoSelect.onServerKick) {
            ConfigUtils configUtils = Utils.util(ConfigUtils.class);
            Utils.util(LobbyUtils.class).findBest(event.getPlayer()).ifPresentOrElse(pingResult -> {
                messageUtils.sendDebugMessage((Audience)event.getPlayer(), "\ud83d\udd01 Redirecting player after kick.");
                event.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)pingResult.server()));
            }, () -> {
                messageUtils.sendDebugMessage((Audience)event.getPlayer(), "<red>\u274c No fallback lobby available after kick.");
                event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)messageUtils.toMessage(configUtils.config().messages.serverDisconnectedMessage, event.getServer(), event.getPlayer())));
            });
        }
    }

    public ProxyServer server() {
        return this.server;
    }
}

