/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.kyori.adventure.audience.Audience;
import net.uebliche.hub.Hub;
import net.uebliche.hub.config.Config;
import net.uebliche.hub.config.Lobby;
import net.uebliche.hub.data.PingResult;
import net.uebliche.hub.utils.ConfigUtils;
import net.uebliche.hub.utils.LobbyUtils;
import net.uebliche.hub.utils.MessageUtils;
import net.uebliche.hub.utils.PlayerUtils;
import net.uebliche.hub.utils.Utils;

public class DebugCommand {
    private final Hub hub;
    protected ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();

    public DebugCommand(Hub hub) {
        this.hub = hub;
    }

    public LiteralArgumentBuilder<CommandSource> create() {
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        PlayerUtils playerUtils = Utils.util(PlayerUtils.class);
        ConfigUtils configUtils = Utils.util(ConfigUtils.class);
        Config config = configUtils.config();
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"debug").requires(commandSource -> {
            Player player;
            return commandSource instanceof Player && playerUtils.canDebug(player = (Player)commandSource) || commandSource instanceof ConsoleCommandSource;
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"disable").requires(commandSource -> config.debug.enabled)).requires(commandSource -> {
            boolean bl;
            if (commandSource instanceof Player) {
                Player player = (Player)commandSource;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        })).executes(commandContext -> {
            configUtils.debug((Audience)commandContext.getSource(), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"enable").requires(commandSource -> !config.debug.enabled)).requires(commandSource -> {
            boolean bl;
            if (commandSource instanceof Player) {
                Player player = (Player)commandSource;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        })).executes(commandContext -> {
            configUtils.debug((Audience)commandContext.getSource(), true);
            return 1;
        }))).then(BrigadierCommand.literalArgumentBuilder((String)"reload").executes(commandContext -> {
            this.executor.execute(() -> configUtils.reload((Audience)commandContext.getSource()));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"messages").requires(commandSource -> config != null && config.messages != null)).requires(commandSource -> {
            if (commandSource instanceof Player) {
                Player player = (Player)commandSource;
                if (Utils.util(PlayerUtils.class).canDebug(player)) return true;
            }
            if (!(commandSource instanceof ConsoleCommandSource)) return false;
            return true;
        })).executes(commandContext -> {
            CommandSource sender = (CommandSource)commandContext.getSource();
            messageUtils.sendDebugCommandMessage((Audience)sender, "\ud83e\udd16 Testing Messages");
            messageUtils.sendDebugCommandMessage((Audience)sender, messageUtils.toMessage(config.systemMessages.playersOnlyCommandMessage, new Object[0]));
            config.lobbies.forEach(lobby -> {
                messageUtils.sendDebugMessage((Audience)sender, "\ud83e\udd16 Testing Messages for Lobby: " + lobby.name);
                RegisteredServer registeredServer = this.hub.server().getAllServers().stream().filter(registeredServer1 -> lobby.filter.matcher(registeredServer1.getServerInfo().getName()).matches()).findFirst().orElse(null);
                if (registeredServer == null) {
                    messageUtils.sendDebugMessage((Audience)sender, "\u274c No Server found!");
                } else {
                    messageUtils.sendDebugCommandMessage((Audience)sender, messageUtils.toMessage(lobby.messages().successMessage == null ? config.messages.successMessage : lobby.messages().successMessage, registeredServer, lobby));
                    messageUtils.sendDebugCommandMessage((Audience)sender, messageUtils.toMessage(lobby.messages().alreadyConnectedMessage == null ? config.messages.alreadyConnectedMessage : lobby.messages().alreadyConnectedMessage, registeredServer, lobby));
                    messageUtils.sendDebugCommandMessage((Audience)sender, messageUtils.toMessage(lobby.messages().connectionInProgressMessage == null ? config.messages.connectionInProgressMessage : lobby.messages().connectionInProgressMessage, registeredServer, lobby));
                    messageUtils.sendDebugCommandMessage((Audience)sender, messageUtils.toMessage(lobby.messages().serverDisconnectedMessage == null ? config.messages.serverDisconnectedMessage : lobby.messages().serverDisconnectedMessage, registeredServer, lobby));
                    messageUtils.sendDebugCommandMessage((Audience)sender, messageUtils.toMessage(lobby.messages().connectionCancelledMessage == null ? config.messages.connectionCancelledMessage : lobby.messages().connectionCancelledMessage, registeredServer, lobby));
                }
            });
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"placeholders").requires(commandSource -> {
            if (commandSource instanceof Player) {
                Player player = (Player)commandSource;
                if (Utils.util(PlayerUtils.class).canDebug(player)) return true;
            }
            if (!(commandSource instanceof ConsoleCommandSource)) return false;
            return true;
        })).requires(commandSource -> config != null && config.messages != null && config.placeholder != null)).then(BrigadierCommand.requiredArgumentBuilder((String)"lobby", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> {
            config.lobbies.forEach(lobby -> suggestionsBuilder.suggest(lobby.name));
            return suggestionsBuilder.buildFuture();
        }).then(BrigadierCommand.requiredArgumentBuilder((String)"server", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> {
            this.hub.server().getAllServers().forEach(registeredServer -> suggestionsBuilder.suggest(registeredServer.getServerInfo().getName()));
            return suggestionsBuilder.buildFuture();
        }).executes(commandContext -> {
            Player player = (Player)commandContext.getSource();
            String lobbyArg = (String)commandContext.getArgument("lobby", String.class);
            String serverArg = (String)commandContext.getArgument("server", String.class);
            Lobby lobby = config.lobbies.stream().filter(l -> l.name.equalsIgnoreCase(lobbyArg)).findFirst().orElse(null);
            if (lobby == null) {
                messageUtils.sendDebugCommandMessage((Audience)player, "\u274c Lobby " + lobbyArg + " not found!");
                return 1;
            }
            RegisteredServer registeredServer = this.hub.server().getServer(serverArg).orElse(null);
            if (registeredServer == null) {
                messageUtils.sendDebugCommandMessage((Audience)player, "\u274c Server " + serverArg + " not found!");
                return 1;
            }
            messageUtils.placeholders(player, lobby, registeredServer).forEach(tagResolver -> messageUtils.sendDebugCommandMessage((Audience)player, messageUtils.toMessage(tagResolver.key() + ": <" + tagResolver.key() + ">", player, lobby, registeredServer)));
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"getLobbies").requires(commandSource -> {
            if (commandSource instanceof Player) {
                Player player = (Player)commandSource;
                if (Utils.util(PlayerUtils.class).canDebug(player)) return true;
            }
            if (!(commandSource instanceof ConsoleCommandSource)) return false;
            return true;
        })).requires(commandSource -> config != null && config.messages != null && config.placeholder != null)).then(BrigadierCommand.requiredArgumentBuilder((String)"lobby", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> {
            config.lobbies.forEach(lobby -> suggestionsBuilder.suggest(lobby.name));
            return suggestionsBuilder.buildFuture();
        }).executes(commandContext -> {
            Player player = (Player)commandContext.getSource();
            String lobbyArg = (String)commandContext.getArgument("lobby", String.class);
            Lobby lobby = config.lobbies.stream().filter(l -> l.name.equalsIgnoreCase(lobbyArg)).findFirst().orElse(null);
            if (lobby == null) {
                messageUtils.sendDebugCommandMessage((Audience)player, "\u274c Lobby " + lobbyArg + " not found!");
                return 1;
            }
            LobbyUtils lobbyUtils = Utils.util(LobbyUtils.class);
            messageUtils.sendDebugCommandMessage((Audience)player, "<gray>\ud83d\udd04 Refreshing lobby cache...</gray>");
            this.executor.execute(() -> {
                try {
                    lobbyUtils.refreshNow().join();
                    List<LobbyUtils.CachedResult> results = lobbyUtils.getCachedResults(player, lobby);
                    if (results.isEmpty()) {
                        messageUtils.sendDebugCommandMessage((Audience)player, "<red>\u274c No cached ping data for " + lobby.name + ".");
                        return;
                    }
                    results.forEach(snapshot -> {
                        PingResult ping = snapshot.result();
                        String serverName = ping.server().getServerInfo().getName();
                        int online = ping.players().getOnline();
                        int max = ping.players().getMax();
                        long latency = ping.latency();
                        long age = snapshot.ageMillis();
                        messageUtils.sendDebugCommandMessage((Audience)player, "<gray>\ud83e\udd16 " + serverName + "</gray> <gold>" + online + "</gold>/<gold>" + max + "</gold> players, latency <aqua>" + latency + "ms</aqua>, cached <yellow>" + age + "ms</yellow> ago.");
                    });
                }
                catch (Exception ignored) {
                    messageUtils.sendDebugCommandMessage((Audience)player, "<red>\u274c Failed to refresh lobby cache.</red>");
                }
            });
            return 1;
        })));
    }
}

