/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub.utils;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.uebliche.hub.Hub;
import net.uebliche.hub.config.Config;
import net.uebliche.hub.utils.MessageUtils;
import net.uebliche.hub.utils.Utils;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.loader.HeaderMode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigUtils
extends Utils<ConfigUtils> {
    private static final String DEBUG_ENV_VARIABLE = "HUB_DEBUG";
    private Config config;
    private YamlConfigurationLoader configLoader;
    private CommentedConfigurationNode node;
    private List<Runnable> onReload = new ArrayList<Runnable>();

    public ConfigUtils(Hub hub, Path dataDirectory) {
        super(hub);
        this.configLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(dataDirectory.resolve("config.yml"))).defaultOptions(opts -> opts.shouldCopyDefaults(true).header("Thanks <3").implicitInitialization(true))).nodeStyle(NodeStyle.BLOCK).indent(2).headerMode(HeaderMode.PRESET)).build();
    }

    public void reload() throws ConfigurateException {
        this.node = (CommentedConfigurationNode)this.configLoader.load();
        this.config = (Config)this.node.get(Config.class);
        this.applyEnvironmentOverrides();
        this.processConfig();
        this.node.set(Config.class, (Object)this.config);
        this.configLoader.save((ConfigurationNode)this.node);
        this.onReload.forEach(Runnable::run);
    }

    public void save(Audience audience) {
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        try {
            this.node.set(Config.class, (Object)this.config);
            this.configLoader.save((ConfigurationNode)this.node);
            this.reload();
        }
        catch (SerializationException e) {
            messageUtils.sendDebugMessage(audience, "<red>\u274c Failed to Serialized Config!");
            messageUtils.sendDebugMessage(audience, e.getMessage());
        }
        catch (ConfigurateException e) {
            messageUtils.sendDebugMessage(audience, "<red>\u274c Failed to Save Config!");
            messageUtils.sendDebugMessage(audience, e.getMessage());
        }
    }

    public void debug(Audience audience, boolean enable) {
        this.config.debug.enabled = enable;
        this.save(audience);
    }

    public void onReload(Runnable runner) {
        this.onReload.add(runner);
    }

    private void processConfig() {
        this.config.lobbies = this.config.lobbies.stream().sorted(Comparator.comparingInt(o -> -o.priority)).toList();
    }

    private void applyEnvironmentOverrides() {
        String debugEnv = System.getenv(DEBUG_ENV_VARIABLE);
        if (debugEnv == null) {
            return;
        }
        Boolean debugOverride = this.parseBoolean(debugEnv);
        if (debugOverride == null) {
            this.logger.warn("Ignoring {} env value '{}'; expected boolean", (Object)DEBUG_ENV_VARIABLE, (Object)debugEnv);
            return;
        }
        this.config.debug.enabled = debugOverride;
    }

    private Boolean parseBoolean(String raw) {
        String value;
        return switch (value = raw.trim().toLowerCase()) {
            case "1", "true", "t", "yes", "y", "on" -> true;
            case "0", "false", "f", "no", "n", "off" -> false;
            default -> null;
        };
    }

    public Config config() {
        return this.config;
    }

    public ConfigUtils setConfig(Config config) {
        this.config = config;
        return this;
    }

    public YamlConfigurationLoader configLoader() {
        return this.configLoader;
    }

    public ConfigUtils setConfigLoader(YamlConfigurationLoader configLoader) {
        this.configLoader = configLoader;
        return this;
    }

    public CommentedConfigurationNode node() {
        return this.node;
    }

    public ConfigUtils setNode(CommentedConfigurationNode node) {
        this.node = node;
        return this;
    }

    public List<Runnable> onReload() {
        return this.onReload;
    }

    public ConfigUtils setOnReload(List<Runnable> onReload) {
        this.onReload = onReload;
        return this;
    }

    public void reload(Audience recipient) {
        MessageUtils messageUtils = Utils.util(MessageUtils.class);
        try {
            this.reload();
            messageUtils.sendDebugCommandMessage(recipient, "<green>\u2714 Reload successful!");
        }
        catch (ConfigurateException e) {
            messageUtils.sendDebugCommandMessage(recipient, "<red>\u274c Reload failed!");
            messageUtils.sendDebugCommandMessage(recipient, e.getMessage());
        }
    }
}

