/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.hub.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.uebliche.hub.Hub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils<T extends Utils<?>>
implements AutoCloseable {
    private static final Map<Class<?>, Utils<?>> UTILS = new ConcurrentHashMap();
    protected final Logger logger = LoggerFactory.getLogger((String)("hub | " + this.getClass().getSimpleName().toLowerCase()));
    protected final Hub hub;

    public Utils(Hub hub) {
        this.hub = hub;
        Utils previous = UTILS.put(this.getClass(), this);
        if (previous != null && previous != this) {
            previous.closeQuietly();
        }
    }

    public static <T> T util(Class<T> utilClass) {
        return (T)UTILS.get(utilClass);
    }

    public static void shutdownAll() {
        UTILS.values().forEach(Utils::closeQuietly);
        UTILS.clear();
    }

    protected void closeQuietly() {
        try {
            this.close();
        }
        catch (Exception e) {
            this.logger.warn("Failed to close {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

