/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions;

import com.mojang.logging.LogUtils;
import com.relimer.ironsrestrictions.Config;
import com.relimer.ironsrestrictions.registries.CreativeTabRegistry;
import com.relimer.ironsrestrictions.registries.ItemRegistry;
import com.relimer.ironsrestrictions.registries.LootConditionRegistry;
import com.relimer.ironsrestrictions.registries.LootModifierRegistry;
import com.relimer.ironsrestrictions.setup.Messages;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="irons_restrictions")
public class IronsRestrictions {
    public static final String MODID = "irons_restrictions";
    public static final Logger LOGGER = LogUtils.getLogger();

    public IronsRestrictions(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ItemRegistry.register(modEventBus);
        CreativeTabRegistry.register(modEventBus);
        LootModifierRegistry.register(modEventBus);
        LootConditionRegistry.register(modEventBus);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(Messages::register);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static ResourceLocation id(@NotNull String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @Mod.EventBusSubscriber(modid="irons_restrictions", value={Dist.CLIENT})
    static class ClientModEvents {
        ClientModEvents() {
        }

        @SubscribeEvent
        static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

