/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.item;

import com.relimer.ironsrestrictions.IronsRestrictions;
import com.relimer.ironsrestrictions.item.ManuscriptData;
import com.relimer.ironsrestrictions.network.OpenSchoolScreenPacket;
import com.relimer.ironsrestrictions.setup.Messages;
import com.relimer.ironsrestrictions.util.SchoolContainer;
import com.relimer.ironsrestrictions.util.SpellUtils;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Manuscript
extends Item {
    public Manuscript() {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
    }

    private SchoolContainer getOrCreate(ItemStack itemStack) {
        return ManuscriptData.getSchoolContainer(itemStack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand pUsedHand) {
        ItemStack itemStack = player.m_21120_(pUsedHand);
        ItemStack offHand = player.m_21206_();
        ItemStack mainHand = player.m_21205_();
        IronsRestrictions.LOGGER.info("Player: " + player);
        ItemStack scrollHand = null;
        if (offHand.m_150930_((Item)ItemRegistry.SCROLL.get())) {
            scrollHand = offHand;
        }
        if (mainHand.m_150930_((Item)ItemRegistry.SCROLL.get())) {
            scrollHand = mainHand;
        }
        if (player instanceof ServerPlayer) {
            SpellData spellSlot;
            AbstractSpell spell;
            SchoolType school;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SchoolContainer schoolComponent = ManuscriptData.getSchoolContainer(itemStack);
            if (scrollHand != null && (school = (spell = (spellSlot = ISpellContainer.getOrCreate((ItemStack)scrollHand).getSpellAtIndex(0)).getSpell()).getSchoolType()) == schoolComponent.getSchoolType() && !spell.isLearned(player) && SpellUtils.getLearnableSpells().contains(spell)) {
                SyncedSpellData data = MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData();
                data.learnSpell(spell);
                IronsRestrictions.LOGGER.info(player.m_7755_().getString() + " learnt Spell: " + spell);
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.irons_restrictions.manuscript.learn_scroll").m_130946_(spell.getDisplayName(player).getString()).m_130940_(ChatFormatting.GOLD), true);
                player.m_6330_((SoundEvent)SoundRegistry.LEARN_ELDRITCH_SPELL.get(), SoundSource.MASTER, 1.0f, (float)Utils.random.m_216332_(9, 11) * 0.1f);
                if (!serverPlayer.f_8941_.m_9295_()) {
                    itemStack.m_41774_(1);
                }
                player.m_36335_().m_41524_(scrollHand.m_41720_(), 20);
                return InteractionResultHolder.m_19090_((Object)itemStack);
            }
            Messages.sendToPlayer(new OpenSchoolScreenPacket(pUsedHand, schoolComponent.getSchoolType()), serverPlayer);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        SchoolContainer data = this.getOrCreate(itemStack);
        return Component.m_237115_((String)data.getManuscriptId());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> lines, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, lines, pIsAdvanced);
        MinecraftInstanceHelper.ifPlayerPresent(player -> {
            SchoolContainer data = this.getOrCreate(pStack);
            lines.add((Component)Component.m_237115_((String)data.getManuscriptDescription()).m_130940_(ChatFormatting.GRAY));
        });
    }
}

