/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.item;

import com.relimer.ironsrestrictions.anim.Animations;
import com.relimer.ironsrestrictions.network.PlayAnimationPacket;
import com.relimer.ironsrestrictions.network.RarityData;
import com.relimer.ironsrestrictions.player.PlayerRarityProvider;
import com.relimer.ironsrestrictions.setup.Messages;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RarityUpgrade
extends Item {
    SpellRarity rarity;
    SpellRarity prevRarity;
    int requiredAdvancements;

    public RarityUpgrade(SpellRarity rarity, SpellRarity previousRarity, int reqAdv) {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41487_(1));
        this.rarity = rarity;
        this.prevRarity = previousRarity;
        this.requiredAdvancements = reqAdv;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand pUsedHand) {
        ItemStack itemStack = player.m_21120_(pUsedHand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            int prevValue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RarityData rarityData = (RarityData)player.getCapability(PlayerRarityProvider.SYNCED_RARITY).orElse((Object)new RarityData(serverPlayer));
            SpellRarity currentRarity = rarityData.getSyncedData().getRarity();
            if (player.m_36335_().m_41519_((Item)this)) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            int value = currentRarity == null ? -1 : currentRarity.getValue();
            if (value < (prevValue = this.prevRarity == null ? -1 : this.prevRarity.getValue())) {
                player.m_5661_((Component)Component.m_237115_((String)"item.irons_restrictions.upgrade.fail_below").m_130940_(ChatFormatting.DARK_RED), true);
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (value > prevValue) {
                player.m_5661_((Component)Component.m_237115_((String)"item.irons_restrictions.upgrade.fail_above").m_130940_(ChatFormatting.DARK_RED), true);
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            player.m_6330_(SoundEvents.f_12521_, SoundSource.MASTER, 1.0f, (float)Utils.random.m_216332_(9, 11) * 0.1f);
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123809_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 0.5, 1.0, 0.5, 0.5);
            rarityData.getSyncedData().setRarity(this.rarity);
            Messages.sendToPlayer(new PlayAnimationPacket(Animations.UPGRADE), serverPlayer);
            if (!serverPlayer.f_8941_.m_9295_()) {
                itemStack.m_41774_(1);
            }
            player.m_36335_().m_41524_((Item)this, 20);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> lines, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, lines, pIsAdvanced);
        MinecraftInstanceHelper.ifPlayerPresent(player -> lines.add((Component)Component.m_237115_((String)"item.irons_restrictions.upgrade_desc").m_130940_(ChatFormatting.GRAY)));
    }
}

