/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.network;

import com.relimer.ironsrestrictions.network.spells.SyncedRarityData;
import com.relimer.ironsrestrictions.player.PlayerRarityProvider;
import com.relimer.ironsrestrictions.util.ConfigurableRarity;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.LazyOptional;

public class RarityData {
    private ServerPlayer serverPlayer = null;
    private SpellRarity rarity;
    private SyncedRarityData syncedRarityData;

    public RarityData(ServerPlayer serverPlayer) {
        this.serverPlayer = serverPlayer;
    }

    public RarityData() {
    }

    public void setServerPlayer(ServerPlayer serverPlayer) {
        if (this.serverPlayer == null && serverPlayer != null) {
            this.serverPlayer = serverPlayer;
        }
    }

    public SyncedRarityData getSyncedData() {
        if (this.syncedRarityData == null) {
            this.syncedRarityData = new SyncedRarityData((LivingEntity)this.serverPlayer);
        }
        return this.syncedRarityData;
    }

    public void setSyncedData(SyncedRarityData syncedRarityData) {
        this.syncedRarityData = syncedRarityData;
    }

    public static RarityData getPlayerRarityData(LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            LazyOptional capContainer = serverPlayer.getCapability(PlayerRarityProvider.SYNCED_RARITY);
            if (capContainer.isPresent()) {
                Optional opt = capContainer.resolve();
                if (opt.isEmpty()) {
                    return new RarityData(serverPlayer);
                }
                RarityData pmd = (RarityData)opt.get();
                pmd.setServerPlayer(serverPlayer);
                return pmd;
            }
            return new RarityData(serverPlayer);
        }
        throw new IllegalArgumentException("Invalid Entity");
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128359_("spell_rarity", this.rarity != null ? this.rarity.name() : "NONE");
        this.getSyncedData().saveNBTData(compound);
    }

    public void loadNBTData(CompoundTag compound) {
        this.rarity = ConfigurableRarity.valueOf(compound.m_128461_("spell_rarity")).getSpellRarity();
        this.getSyncedData().loadNBTData(compound);
    }
}

