/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.network.spells;

import com.relimer.ironsrestrictions.registries.ItemRegistry;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class RLearnSpellPacket {
    private final byte hand;
    private final String spell;

    public RLearnSpellPacket(InteractionHand interactionHand, String spell) {
        this.hand = RLearnSpellPacket.handToByte(interactionHand);
        this.spell = spell;
    }

    public RLearnSpellPacket(FriendlyByteBuf buf) {
        this.hand = buf.readByte();
        this.spell = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte((int)this.hand);
        buf.m_130070_(this.spell);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayer = ctx.getSender();
            ItemStack itemStack = serverPlayer.m_21120_(RLearnSpellPacket.byteToHand(this.hand));
            AbstractSpell spell = SpellRegistry.getSpell((String)this.spell);
            SyncedSpellData data = MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData();
            if (spell != SpellRegistry.none() && !data.isSpellLearned(spell) && itemStack.m_150930_((Item)ItemRegistry.MANUSCRIPT.get()) && itemStack.m_41613_() > 0) {
                data.learnSpell(spell);
                if (!serverPlayer.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static byte handToByte(InteractionHand hand) {
        return (byte)(hand == InteractionHand.MAIN_HAND ? 1 : 0);
    }

    public static InteractionHand byteToHand(byte b) {
        return b > 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }
}

