/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.network.spells;

import com.relimer.ironsrestrictions.Config;
import com.relimer.ironsrestrictions.network.spells.SyncPlayerRarityDataPacket;
import com.relimer.ironsrestrictions.setup.Messages;
import com.relimer.ironsrestrictions.util.ConfigurableRarity;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class SyncedRarityData {
    private final int serverPlayerId;
    @Nullable
    private LivingEntity livingEntity;
    private SpellRarity rarity;
    private SyncedRarityData syncedRarityData;
    public static final EntityDataSerializer<SyncedRarityData> SYNCED_RARITY_DATA = new EntityDataSerializer.ForValueType<SyncedRarityData>(){

        public void write(FriendlyByteBuf buffer, SyncedRarityData data) {
            buffer.writeInt(data.serverPlayerId);
            buffer.writeBoolean(data.rarity != null);
            if (data.rarity != null) {
                buffer.m_130068_((Enum)data.rarity);
            }
        }

        public SyncedRarityData read(FriendlyByteBuf buffer) {
            SyncedRarityData data = new SyncedRarityData(buffer.readInt());
            data.rarity = buffer.readBoolean() ? (SpellRarity)buffer.m_130066_(SpellRarity.class) : ((ConfigurableRarity)((Object)Config.StartingRarity.get())).getSpellRarity();
            return data;
        }
    };

    public SyncedRarityData(int serverPlayerId) {
        this.serverPlayerId = serverPlayerId;
        this.livingEntity = null;
        this.rarity = ((ConfigurableRarity)((Object)Config.StartingRarity.get())).getSpellRarity();
    }

    public SyncedRarityData(LivingEntity livingEntity) {
        this(livingEntity == null ? -1 : livingEntity.m_19879_());
        this.livingEntity = livingEntity;
    }

    public SpellRarity getRarity() {
        return this.rarity;
    }

    public void setRarity(SpellRarity newRarity) {
        if (this.rarity != newRarity) {
            this.rarity = newRarity;
            this.doSync();
        }
    }

    public void doSync() {
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Messages.sendToPlayer(new SyncPlayerRarityDataPacket(this), serverPlayer);
            Messages.sendToPlayersTrackingEntity(new SyncPlayerRarityDataPacket(this), (Entity)serverPlayer);
        }
    }

    public void copyFrom(SyncedRarityData other) {
        this.setRarity(other.getRarity());
    }

    public int getServerPlayerId() {
        return this.serverPlayerId;
    }

    public SyncedRarityData getPersistentData() {
        SyncedRarityData persistentData = new SyncedRarityData(this.livingEntity);
        persistentData.rarity = this.rarity;
        return persistentData;
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128359_("spell_rarity", this.rarity.toString());
    }

    public void loadNBTData(CompoundTag compound) {
        this.rarity = SpellRarity.valueOf((String)compound.m_128461_("spell_rarity"));
    }
}

