/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.player;

import com.relimer.ironsrestrictions.IronsRestrictions;
import com.relimer.ironsrestrictions.network.RarityData;
import com.relimer.ironsrestrictions.player.PlayerRarityProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="irons_restrictions")
public class PlayerRarityEvents {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)"spell_rarity");

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)object;
            IronsRestrictions.LOGGER.info("[ISS RESTRICTIONS] Attached Capability to player {}", (Object)serverPlayer.m_20148_());
            event.addCapability(ID, (ICapabilityProvider)new PlayerRarityProvider(serverPlayer));
        }
    }

    @SubscribeEvent
    public static void clone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newServerPlayer = (ServerPlayer)player;
            event.getOriginal().reviveCaps();
            RarityData oldMagicData = RarityData.getPlayerRarityData((LivingEntity)event.getOriginal());
            RarityData newMagicData = RarityData.getPlayerRarityData((LivingEntity)event.getEntity());
            newMagicData.setSyncedData(oldMagicData.getSyncedData().getPersistentData());
            newMagicData.getSyncedData().doSync();
            event.getOriginal().invalidateCaps();
        }
    }
}

