/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.player;

import com.relimer.ironsrestrictions.network.RarityData;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="irons_restrictions")
public class PlayerRarityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<RarityData> SYNCED_RARITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<RarityData>(){});
    private RarityData playerRarityData = null;
    private LazyOptional<RarityData> optional = LazyOptional.of(this::createPlayerMagicData);
    private ServerPlayer serverPlayer;

    public PlayerRarityProvider(ServerPlayer serverPlayer) {
        this.serverPlayer = serverPlayer;
    }

    @Nonnull
    private RarityData createPlayerMagicData() {
        if (this.playerRarityData == null) {
            this.playerRarityData = new RarityData(this.serverPlayer);
        }
        return this.playerRarityData;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == SYNCED_RARITY) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.createPlayerMagicData().saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createPlayerMagicData().loadNBTData(nbt);
    }
}

