/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.setup;

import com.relimer.ironsrestrictions.Config;
import com.relimer.ironsrestrictions.IronsRestrictions;
import com.relimer.ironsrestrictions.item.ManuscriptData;
import com.relimer.ironsrestrictions.registries.ItemRegistry;
import com.relimer.ironsrestrictions.render.ManuscriptModel;
import com.relimer.ironsrestrictions.util.SchoolContainer;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="irons_restrictions", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    @SubscribeEvent
    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            SchoolContainer schoolContainer;
            if ((((Boolean)Config.TintBasePage.get()).booleanValue() && tintIndex == 1 || ((Boolean)Config.TintOverlayPage.get()).booleanValue() && tintIndex == 2) && (schoolContainer = ManuscriptData.getSchoolContainer(stack)) != null) {
                return schoolContainer.getSchoolColour();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ItemRegistry.MANUSCRIPT.get()});
    }

    @SubscribeEvent
    public static void registerSpecialModels(ModelEvent.RegisterAdditional event) {
        for (SchoolType schoolType : (IForgeRegistry)SchoolRegistry.REGISTRY.get()) {
            ResourceLocation location = ManuscriptModel.getManuscriptModelLocation(schoolType);
            event.register(location);
        }
    }

    @SubscribeEvent
    public static void replaceItemModels(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation key = new ModelResourceLocation(IronsRestrictions.id("manuscript"), "inventory");
        event.getModels().computeIfPresent(key, (k, oldModel) -> new ManuscriptModel((BakedModel)oldModel, event.getModelBakery()){});
    }
}

