/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.setup;

import com.relimer.ironsrestrictions.network.OpenSchoolScreenPacket;
import com.relimer.ironsrestrictions.network.PlayAnimationPacket;
import com.relimer.ironsrestrictions.network.spells.RLearnSpellPacket;
import com.relimer.ironsrestrictions.network.spells.SyncPlayerRarityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class Messages {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)"messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(OpenSchoolScreenPacket.class, Messages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(OpenSchoolScreenPacket::new).encoder(OpenSchoolScreenPacket::toBytes).consumerMainThread(OpenSchoolScreenPacket::handle).add();
        net.messageBuilder(RLearnSpellPacket.class, Messages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(RLearnSpellPacket::new).encoder(RLearnSpellPacket::toBytes).consumerMainThread(RLearnSpellPacket::handle).add();
        net.messageBuilder(SyncPlayerRarityDataPacket.class, Messages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(SyncPlayerRarityDataPacket::new).encoder(SyncPlayerRarityDataPacket::toBytes).consumerMainThread(SyncPlayerRarityDataPacket::handle).add();
        net.messageBuilder(PlayAnimationPacket.class, Messages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(PlayAnimationPacket::new).encoder(PlayAnimationPacket::toBytes).consumerMainThread(PlayAnimationPacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToAllPlayers(MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void sendToPlayersTrackingEntity(MSG message, Entity entity) {
        Messages.sendToPlayersTrackingEntity(message, entity, false);
    }

    public static <MSG> void sendToPlayersTrackingEntity(MSG message, Entity entity, boolean sendToSource) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
        if (sendToSource && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Messages.sendToPlayer(message, serverPlayer);
        }
    }

    static {
        packetId = 0;
    }
}

