/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.util;

import com.mojang.serialization.Codec;
import com.relimer.ironsrestrictions.util.ISchoolContainer;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public class SchoolContainer
implements ISchoolContainer {
    private final SchoolType schoolType;
    public static final Codec<SchoolType> SCHOOL_TYPE_CODEC = ((IForgeRegistry)SchoolRegistry.REGISTRY.get()).getCodec();
    public static final Codec<SchoolContainer> CODEC = SCHOOL_TYPE_CODEC.xmap(SchoolContainer::new, SchoolContainer::getSchoolType);

    public SchoolContainer(SchoolType schoolType) {
        this.schoolType = schoolType;
    }

    public String getManuscriptId() {
        return String.format("item.%s.%s_manuscript", "irons_restrictions", this.getSchoolId().m_135815_());
    }

    public String getManuscriptDescription() {
        return String.format("item.%s.%s_manuscript_desc", "irons_restrictions", this.getSchoolId().m_135815_());
    }

    public String getKnowledgeFragmentID() {
        return String.format("item.%s.%s_knowledge_fragment", "irons_restrictions", this.getSchoolId().m_135815_());
    }

    public SchoolType getSchoolType() {
        return this.schoolType;
    }

    public int getSchoolColour() {
        return 0xFF000000 | Objects.requireNonNull(this.schoolType.getDisplayName().m_7383_().m_131135_()).m_131265_();
    }

    @Override
    public ResourceLocation getSchoolId() {
        return this.schoolType.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchoolContainer that = (SchoolContainer)o;
        return this.schoolType.equals(that.schoolType);
    }

    public int hashCode() {
        return this.schoolType.hashCode();
    }

    public static SchoolContainer readFromBuffer(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        SchoolType school = (SchoolType)((IForgeRegistry)SchoolRegistry.REGISTRY.get()).getValue(id);
        return new SchoolContainer(school != null ? school : (SchoolType)SchoolRegistry.FIRE.get());
    }

    public static void writeToBuffer(FriendlyByteBuf buf, SchoolContainer container) {
        buf.m_130085_(container.getSchoolId());
    }
}

