/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.ironsrestrictionsmixin;

import com.relimer.ironsrestrictions.Config;
import com.relimer.ironsrestrictions.compat.FallenGemsAffixSpellCastTrigger;
import com.relimer.ironsrestrictions.network.RarityData;
import com.relimer.ironsrestrictions.player.PlayerRarityProvider;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={AbstractSpell.class})
public abstract class AbstractSpellMixin {
    private static final Style ELDRITCH_OBFUSCATED_STYLE = Style.f_131099_.m_178524_(Boolean.valueOf(true)).m_131150_(ResourceLocation.withDefaultNamespace((String)"alt"));

    @Shadow(remap=false)
    public abstract boolean obfuscateStats(Player var1);

    @Shadow(remap=false)
    public abstract boolean isLearned(Player var1);

    @Shadow(remap=false)
    public abstract boolean needsLearning();

    @Shadow(remap=false)
    public abstract String getComponentId();

    @Inject(method={"canBeCastedBy"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void canBeCastedBy(int spellLevel, CastSource castSource, MagicData playerMagicData, Player player, CallbackInfoReturnable<CastResult> cir) {
        AbstractSpell spell = (AbstractSpell)this;
        if (this.needsLearning() && this.learnedOrImbued(spell, player) && !this.irons_Restrictions$hasUnlockedRarity(spell, spellLevel, player)) {
            cir.setReturnValue((Object)new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237115_((String)"ui.irons_restrictions.cast_error_rarity").m_130940_(ChatFormatting.RED)));
        }
        if (this.needsLearning() && !this.learnedOrImbued(spell, player)) {
            cir.setReturnValue((Object)new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_unlearned").m_130940_(ChatFormatting.RED)));
        }
    }

    private boolean learnedOrImbued(AbstractSpell spell, Player player) {
        LazyOptional curiosHandlerOpt;
        if (player == null) {
            return false;
        }
        if (spell.isLearned(player)) {
            return true;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack held = player.m_21120_(hand);
            if (!this.irons_Restrictions$isSpellImbued(held, spell)) continue;
            return true;
        }
        for (ItemStack armorItem : player.m_6168_()) {
            if (!this.irons_Restrictions$isSpellImbued(armorItem, spell)) continue;
            return true;
        }
        if (ModList.get().isLoaded("curios") && (curiosHandlerOpt = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)curiosHandlerOpt.orElse(null);
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                for (int i = 0; i < ((ICurioStacksHandler)entry.getValue()).getSlots(); ++i) {
                    ItemStack curioStack = ((ICurioStacksHandler)entry.getValue()).getStacks().getStackInSlot(i);
                    if (!this.irons_Restrictions$isSpellImbued(curioStack, spell)) continue;
                    return true;
                }
            }
        }
        if (ModList.get().isLoaded("fallen_gems_affixes")) {
            return FallenGemsAffixSpellCastTrigger.getter(player);
        }
        return false;
    }

    @Unique
    private boolean irons_Restrictions$hasUnlockedRarity(AbstractSpell abstractSpell, int spellLevel, Player player) {
        SpellRarity rarity = abstractSpell.getRarity(spellLevel);
        int minLevel = abstractSpell.getMinLevelForRarity(rarity);
        RarityData rarityData = (RarityData)player.getCapability(PlayerRarityProvider.SYNCED_RARITY).orElse((Object)new RarityData((ServerPlayer)player));
        SpellRarity currentRarity = rarityData.getSyncedData().getRarity();
        if (currentRarity == null) {
            return this.irons_Restrictions$imbuedChecks(abstractSpell, player);
        }
        if (minLevel <= abstractSpell.getMinLevelForRarity(currentRarity)) {
            return true;
        }
        return this.irons_Restrictions$imbuedChecks(abstractSpell, player);
    }

    @Unique
    private boolean irons_Restrictions$imbuedChecks(AbstractSpell spell, Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack held = player.m_21120_(hand);
            if (!this.irons_Restrictions$isSpellImbued(held, spell)) continue;
            return true;
        }
        for (ItemStack armorItem : player.m_6168_()) {
            if (!this.irons_Restrictions$isSpellImbued(armorItem, spell)) continue;
            return true;
        }
        Optional curiosHandlerOpt = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (curiosHandlerOpt.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)curiosHandlerOpt.get();
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                for (int i = 0; i < ((ICurioStacksHandler)entry.getValue()).getSlots(); ++i) {
                    ItemStack curioStack = ((ICurioStacksHandler)entry.getValue()).getStacks().getStackInSlot(i);
                    if (!this.irons_Restrictions$isSpellImbued(curioStack, spell)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Unique
    private boolean irons_Restrictions$isSpellImbued(ItemStack itemStack, AbstractSpell abstractSpell) {
        ISpellContainer container;
        if (itemStack.m_41720_() instanceof SpellBook || itemStack.m_41720_() instanceof Scroll || ((Boolean)Config.ImbuedItemsRequireLearning.get()).equals(true)) {
            return false;
        }
        if (ISpellContainer.isSpellContainer((ItemStack)itemStack) && (container = ISpellContainer.get((ItemStack)itemStack)) != null) {
            for (SpellData spellSlot : container.getAllSpells()) {
                if (spellSlot.getSpell() != abstractSpell) continue;
                return true;
            }
        }
        return false;
    }

    @Inject(method={"getDisplayName"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getDisplayName(Player player, CallbackInfoReturnable<MutableComponent> cir) {
        boolean obfuscateName = player != null && this.obfuscateStats(player);
        MutableComponent name = Component.m_237115_((String)this.getComponentId()).m_130948_(obfuscateName ? ELDRITCH_OBFUSCATED_STYLE : Style.f_131099_);
        cir.setReturnValue((Object)name);
    }

    @Inject(method={"obfuscateStats"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void overrideObfuscateStats(@Nullable Player player, CallbackInfoReturnable<Boolean> cir) {
        boolean result = this.needsLearning() && !this.isLearned(player);
        cir.setReturnValue((Object)result);
    }

    @Inject(method={"isLearned"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void overrideIsLearned(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (player == null) {
            cir.setReturnValue((Object)false);
        } else if (player.m_9236_().f_46443_) {
            cir.setReturnValue((Object)ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned((AbstractSpell)this));
        } else {
            cir.setReturnValue((Object)MagicData.getPlayerMagicData((LivingEntity)player).getSyncedData().isSpellLearned((AbstractSpell)this));
        }
    }

    @Inject(method={"needsLearning"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void overrideNeedsLearning(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)true);
    }
}

