/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.curses;

import java.util.UUID;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.curses.CurseType;
import net.favouriteless.enchanted.common.init.registry.ESoundEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2765;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public abstract class Curse {
    public static final int MIN_WHISPER_TIME = 120;
    public static final int MAX_WHISPER_TIME = 240;
    public static final double WHISPER_CHANCE = 4.166666666666667E-4;
    public final CurseType<?> type;
    protected UUID targetUUID;
    protected UUID casterUUID;
    protected int level;
    protected class_3222 targetPlayer;
    protected long ticks = 0L;
    private long lastWhisper = 0L;

    public Curse(CurseType<?> type) {
        this.type = type;
    }

    public void tick(class_3218 level) {
        long timeSinceWhisper;
        if (this.targetPlayer == null || this.targetPlayer.method_31481()) {
            this.targetPlayer = level.method_8503().method_3760().method_14602(this.targetUUID);
        }
        if (this.targetPlayer != null) {
            this.onTick();
        }
        if ((timeSinceWhisper = this.ticks - this.lastWhisper) > 4800L) {
            this.whisper();
        } else if (timeSinceWhisper > 2400L && Math.random() < 4.166666666666667E-4) {
            this.whisper();
        }
        ++this.ticks;
    }

    protected abstract void onTick();

    private void whisper() {
        if (this.targetPlayer != null) {
            this.lastWhisper = this.ticks;
            this.targetPlayer.field_13987.method_14364((class_2596)new class_2765(class_7923.field_41172.method_47983((Object)ESoundEvents.CURSE_WHISPER.get()), class_3419.field_15256, (class_1297)this.targetPlayer, 0.3f, (float)Math.random() * 0.15f + 0.85f, Enchanted.RANDOM.nextLong()));
        }
    }

    public CurseType<?> getType() {
        return this.type;
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public void setTarget(UUID targetUUID) {
        this.targetUUID = targetUUID;
    }

    public void setTarget(class_3222 player) {
        this.targetUUID = player.method_5667();
        this.targetPlayer = player;
    }

    public void setCaster(UUID casterUUID) {
        this.casterUUID = casterUUID;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void save(class_2487 nbt) {
        nbt.method_10582("type", this.type.getId().toString());
        nbt.method_25927("target", this.targetUUID);
        nbt.method_25927("caster", this.casterUUID);
        nbt.method_10544("ticks", this.ticks);
        nbt.method_10569("level", this.level);
        this.saveAdditional(nbt);
    }

    public void load(class_2487 nbt) {
        this.targetUUID = nbt.method_25926("target");
        this.casterUUID = nbt.method_25926("caster");
        this.ticks = nbt.method_10537("ticks");
        this.level = nbt.method_10550("level");
        this.loadAdditional(nbt);
    }

    protected void saveAdditional(class_2487 nbt) {
    }

    protected void loadAdditional(class_2487 nbt) {
    }

    public void onRemove(class_3218 level) {
    }
}

