/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client;

import net.favouriteless.enchanted.client.render.blockentity.CauldronWaterRenderer;
import net.favouriteless.enchanted.client.render.blockentity.PoppetShelfRenderer;
import net.favouriteless.enchanted.client.render.blockentity.SpinningWheelRenderer;
import net.favouriteless.enchanted.client.render.entity.BroomstickRenderer;
import net.favouriteless.enchanted.client.render.entity.FamiliarCatRenderer;
import net.favouriteless.enchanted.client.render.entity.SimpleAnimatedGeoRenderer;
import net.favouriteless.enchanted.client.render.model.ModelLayerLocations;
import net.favouriteless.enchanted.client.render.model.entity.BroomstickModel;
import net.favouriteless.enchanted.client.screens.AltarScreen;
import net.favouriteless.enchanted.client.screens.DistilleryScreen;
import net.favouriteless.enchanted.client.screens.PoppetShelfScreen;
import net.favouriteless.enchanted.client.screens.SpinningWheelScreen;
import net.favouriteless.enchanted.client.screens.WitchOvenScreen;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.registry.EBlocks;
import net.favouriteless.enchanted.common.init.registry.EEntityTypes;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.init.registry.EMenuTypes;
import net.favouriteless.enchanted.common.init.registry.EnchantedBlockEntityTypes;
import net.favouriteless.enchanted.platform.ClientServices;
import net.favouriteless.enchanted.platform.services.IClientRegistryHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_7923;
import net.minecraft.class_916;
import net.minecraft.class_953;

public class ClientRegistry {
    public static void register() {
        class_3929.method_17542(EMenuTypes.WITCH_OVEN.get(), WitchOvenScreen::new);
        class_3929.method_17542(EMenuTypes.DISTILLERY.get(), DistilleryScreen::new);
        class_3929.method_17542(EMenuTypes.ALTAR.get(), AltarScreen::new);
        class_3929.method_17542(EMenuTypes.SPINNING_WHEEL.get(), SpinningWheelScreen::new);
        class_3929.method_17542(EMenuTypes.POPPET_SHELF.get(), PoppetShelfScreen::new);
    }

    public static void registerEntityRenderers() {
        IClientRegistryHelper registry = ClientServices.CLIENT_REGISTRY;
        registry.register(EEntityTypes.MANDRAKE.get(), context -> new SimpleAnimatedGeoRenderer(context, "mandrake"));
        registry.register(EEntityTypes.BROOMSTICK.get(), BroomstickRenderer::new);
        registry.register(EEntityTypes.THROWABLE_BREW.get(), class_953::new);
        registry.register(EEntityTypes.FAMILIAR_CAT.get(), FamiliarCatRenderer::new);
        registry.register(EEntityTypes.VOODOO_ITEM.get(), class_916::new);
        registry.register(EnchantedBlockEntityTypes.WITCH_CAULDRON.get(), context -> new CauldronWaterRenderer(12.0f));
        registry.register(EnchantedBlockEntityTypes.KETTLE.get(), context -> new CauldronWaterRenderer(8.0f));
        registry.register(EnchantedBlockEntityTypes.SPINNING_WHEEL.get(), SpinningWheelRenderer::new);
        registry.register(EnchantedBlockEntityTypes.POPPET_SHELF.get(), PoppetShelfRenderer::new);
    }

    public static void registerLayerDefinitions() {
        IClientRegistryHelper registry = ClientServices.CLIENT_REGISTRY;
        registry.register(ModelLayerLocations.BROOMSTICK, BroomstickModel::createLayerDefinition);
        registry.register(ModelLayerLocations.SPINNING_WHEEL, SpinningWheelRenderer::createLayerDefinition);
    }

    public static void registerItemModelPredicates() {
        IClientRegistryHelper registry = ClientServices.CLIENT_REGISTRY;
        registry.register(EItems.CIRCLE_TALISMAN.get(), Enchanted.id("small"), (stack, level, entity, seed) -> ClientRegistry.talismanTexturePred(stack, Enchanted.id("small_circle")));
        registry.register(EItems.CIRCLE_TALISMAN.get(), Enchanted.id("medium"), (stack, level, entity, seed) -> ClientRegistry.talismanTexturePred(stack, Enchanted.id("medium_circle")));
        registry.register(EItems.CIRCLE_TALISMAN.get(), Enchanted.id("large"), (stack, level, entity, seed) -> ClientRegistry.talismanTexturePred(stack, Enchanted.id("large_circle")));
    }

    protected static float talismanTexturePred(class_1799 stack, class_2960 id) {
        if (!stack.method_7985()) {
            return 0.0f;
        }
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(stack.method_7969().method_10562("circle_magic_shape_map").method_10558(id.toString())));
        if (block == EBlocks.RITUAL_CHALK.get()) {
            return 0.3f;
        }
        if (block == EBlocks.NETHER_CHALK.get()) {
            return 0.6f;
        }
        if (block == EBlocks.OTHERWHERE_CHALK.get()) {
            return 0.9f;
        }
        return 0.0f;
    }
}

