/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles.types;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.favouriteless.enchanted.common.util.EExtraCodecs;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_5253;

public class ColouredCircleOptions
implements class_2394 {
    public static final class_2394.class_2395<ColouredCircleOptions> DESERIALIZER = new class_2394.class_2395<ColouredCircleOptions>(){

        public ColouredCircleOptions fromCommand(class_2396<ColouredCircleOptions> particleType, StringReader stringReader) throws CommandSyntaxException {
            int colour = stringReader.readInt();
            class_243 center = new class_243(stringReader.readDouble(), stringReader.readDouble(), stringReader.readDouble());
            float radius = stringReader.readFloat();
            return new ColouredCircleOptions(particleType, colour, center, radius);
        }

        public ColouredCircleOptions fromNetwork(class_2396<ColouredCircleOptions> particleType, class_2540 friendlyByteBuf) {
            int colour = friendlyByteBuf.readInt();
            class_243 center = new class_243(friendlyByteBuf.method_49069());
            float radius = friendlyByteBuf.readFloat();
            return new ColouredCircleOptions(particleType, colour, center, radius);
        }
    };
    private final class_2396<ColouredCircleOptions> particleType;
    private final int colour;
    private final class_243 center;
    private final float radius;

    public ColouredCircleOptions(class_2396<ColouredCircleOptions> particleType, int colour, class_243 center, float radius) {
        this.particleType = particleType;
        this.colour = colour;
        this.radius = radius;
        this.center = center;
    }

    public static MapCodec<ColouredCircleOptions> codec(class_2396<ColouredCircleOptions> type) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("colour").forGetter(data -> data.colour), (App)EExtraCodecs.VEC3.fieldOf("center").forGetter(data -> data.center), (App)Codec.FLOAT.fieldOf("radius").forGetter(data -> Float.valueOf(data.radius))).apply((Applicative)instance, (colour, center, radius) -> new ColouredCircleOptions(type, (int)colour, (class_243)center, radius.floatValue())));
    }

    public float getRed() {
        return (float)class_5253.class_5254.method_27765((int)this.colour) / 255.0f;
    }

    public float getGreen() {
        return (float)class_5253.class_5254.method_27766((int)this.colour) / 255.0f;
    }

    public float getBlue() {
        return (float)class_5253.class_5254.method_27767((int)this.colour) / 255.0f;
    }

    public float getAlpha() {
        return (float)class_5253.class_5254.method_27762((int)this.colour) / 255.0f;
    }

    public float getRadius() {
        return this.radius;
    }

    public class_243 getCenter() {
        return this.center;
    }

    public class_2396<?> method_10295() {
        return this.particleType;
    }

    public void method_10294(class_2540 friendlyByteBuf) {
        friendlyByteBuf.writeInt(this.colour);
        friendlyByteBuf.method_49068(this.center.method_46409());
        friendlyByteBuf.writeFloat(this.radius);
    }

    public String method_10293() {
        return this.colour + " " + this.center.field_1352 + " " + this.center.field_1351 + " " + this.center.field_1350 + " " + this.radius;
    }
}

