/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.render.poppet;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.favouriteless.enchanted.client.render.poppet.PoppetAnimation;
import net.favouriteless.enchanted.common.poppet.PoppetUseResult;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import org.joml.Vector3f;

public class PoppetAnimationManager {
    private static final List<PoppetAnimation> ACTIVE_ANIMATIONS = new ArrayList<PoppetAnimation>();
    private static final Vector3f DIFFUSE_LIGHT_0 = (Vector3f)class_156.method_654((Object)new Vector3f(0.2f, 0.24f, -0.7f), Vector3f::normalize);
    private static final Vector3f DIFFUSE_LIGHT_1 = (Vector3f)class_156.method_654((Object)new Vector3f(-0.2f, 0.24f, 0.7f), Vector3f::normalize);

    public static void startAnimation(PoppetUseResult.ResultType result, class_1799 itemStack) {
        switch (result) {
            case SUCCESS: 
            case SUCCESS_BREAK: {
                PoppetAnimationManager.startAnimation(new PoppetAnimation(itemStack, 120));
            }
        }
    }

    public static void startAnimation(PoppetAnimation animation) {
        ACTIVE_ANIMATIONS.add(animation);
    }

    public static void tick() {
        for (PoppetAnimation animation : ACTIVE_ANIMATIONS) {
            animation.tick();
        }
        ACTIVE_ANIMATIONS.removeIf(anim -> anim.ticks <= 0);
    }

    public static void render(class_332 graphics, float partialTicks, int widthScaled, int heightScaled) {
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)DIFFUSE_LIGHT_0, (Vector3f)DIFFUSE_LIGHT_1);
        for (PoppetAnimation animation : ACTIVE_ANIMATIONS) {
            animation.render(graphics.method_51448(), partialTicks, widthScaled, heightScaled);
        }
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
    }
}

