/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.altar;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.favouriteless.enchanted.common.altar.PowerProvider;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.init.EnchantedTags;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class AltarBlockData {
    private boolean isInitialised = false;
    public Map<class_2248, Integer> blockCounts = new HashMap<class_2248, Integer>();
    public Map<class_6862<class_2248>, Integer> tagCounts = new HashMap<class_6862<class_2248>, Integer>();

    public int addBlock(class_1937 level, class_2248 block) {
        this.tryInitialise(level);
        PowerProvider<class_2248> blockProvider = PowerProvider.getBlock(level, block);
        if (blockProvider != null) {
            int count = this.blockCounts.computeIfAbsent(block, k -> 0);
            this.blockCounts.put(block, count + 1);
            return count < blockProvider.limit() ? blockProvider.power() : 0;
        }
        Optional registry = level.method_30349().method_33310(EData.ALTAR_TAG_REGISTRY);
        if (registry.isPresent()) {
            for (PowerProvider provider : (class_2378)registry.get()) {
                if (!block.method_40142().method_40220((class_6862)provider.key())) continue;
                int count = this.tagCounts.computeIfAbsent((class_6862<class_2248>)((class_6862)provider.key()), k -> 0);
                this.tagCounts.put((class_6862<class_2248>)((class_6862)provider.key()), count + 1);
                return count < provider.limit() ? provider.power() : 0;
            }
        }
        return 0;
    }

    public int removeBlock(class_1937 level, class_2248 block) {
        this.tryInitialise(level);
        PowerProvider<class_2248> blockProvider = PowerProvider.getBlock(level, block);
        if (blockProvider != null) {
            int count = this.blockCounts.computeIfAbsent(block, k -> 0);
            if (count == 1) {
                this.blockCounts.remove(block);
            } else {
                this.blockCounts.put(block, count - 1);
            }
            return count > blockProvider.limit() ? 0 : blockProvider.power();
        }
        Optional registry = level.method_30349().method_33310(EData.ALTAR_TAG_REGISTRY);
        if (registry.isPresent()) {
            for (PowerProvider provider : (class_2378)registry.get()) {
                if (!block.method_40142().method_40220((class_6862)provider.key())) continue;
                int count = this.tagCounts.computeIfAbsent((class_6862<class_2248>)((class_6862)provider.key()), k -> 0);
                if (count == 1) {
                    this.tagCounts.remove(provider.key());
                } else {
                    this.tagCounts.put((class_6862<class_2248>)((class_6862)provider.key()), count - 1);
                }
                return count > provider.limit() ? 0 : provider.power();
            }
        }
        return 0;
    }

    public double calculatePower(class_1937 level, double powerMultiplier) {
        PowerProvider<class_2248> provider;
        this.tryInitialise(level);
        double newPower = 0.0;
        for (class_2248 class_22482 : this.blockCounts.keySet()) {
            provider = PowerProvider.getBlock(level, class_22482);
            if (provider == null) continue;
            newPower += (double)(Math.max(0, Math.min(provider.limit(), this.blockCounts.get(class_22482))) * provider.power()) * powerMultiplier;
        }
        for (class_6862 class_68622 : this.tagCounts.keySet()) {
            provider = PowerProvider.getTag(level, (class_6862<class_2248>)class_68622);
            if (provider == null) continue;
            newPower += (double)(Math.max(0, Math.min(provider.limit(), this.tagCounts.get(class_68622))) * provider.power()) * powerMultiplier;
        }
        return newPower;
    }

    public void reset() {
        this.blockCounts.clear();
        this.tagCounts.clear();
    }

    public class_2487 save() {
        class_2487 nbt = new class_2487();
        class_2487 blockNbt = new class_2487();
        class_2487 tagNbt = new class_2487();
        for (class_2248 class_22482 : this.blockCounts.keySet()) {
            blockNbt.method_10569(class_7923.field_41175.method_10221((Object)class_22482).toString(), this.blockCounts.get(class_22482).intValue());
        }
        for (class_6862 class_68622 : this.tagCounts.keySet()) {
            tagNbt.method_10569(class_68622.comp_327().toString(), this.tagCounts.get(class_68622).intValue());
        }
        nbt.method_10566("blockCounts", (class_2520)blockNbt);
        nbt.method_10566("tagsCounts", (class_2520)tagNbt);
        return nbt;
    }

    public void load(class_2487 nbt) {
        class_2487 blockNbt = nbt.method_10562("blockCounts");
        class_2487 tagNbt = nbt.method_10562("tagsCounts");
        for (String name : blockNbt.method_10541()) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(name));
            if (block == class_2246.field_10124) continue;
            this.blockCounts.put(block, blockNbt.method_10550(name));
        }
        for (String name : tagNbt.method_10541()) {
            this.tagCounts.put(EnchantedTags.createBlockTag(new class_2960(name)), tagNbt.method_10550(name));
        }
        this.isInitialised = false;
    }

    private void tryInitialise(class_1937 level) {
        if (!this.isInitialised) {
            for (class_2248 class_22482 : this.blockCounts.keySet()) {
                if (PowerProvider.getBlock(level, class_22482) != null) continue;
                this.blockCounts.remove(class_22482);
            }
            for (class_6862 class_68622 : this.tagCounts.keySet()) {
                if (PowerProvider.getTag(level, (class_6862<class_2248>)class_68622) != null) continue;
                this.tagCounts.remove(class_68622);
            }
            this.isInitialised = true;
        }
    }
}

