/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.altar;

import java.util.HashMap;
import java.util.Map;
import net.favouriteless.enchanted.common.altar.AltarUpgrade;
import net.favouriteless.enchanted.common.init.EData;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class AltarUpgradeData {
    private final Map<class_2960, Integer> loadData = new HashMap<class_2960, Integer>();
    private boolean isInitialised = false;
    private final Map<class_2960, Map<AltarUpgrade, Integer>> upgrades = new HashMap<class_2960, Map<AltarUpgrade, Integer>>();

    public boolean addBlock(class_1937 level, class_2248 block) {
        Map type;
        this.tryInitialise(level);
        AltarUpgrade upgrade = AltarUpgrade.get(level, block);
        if (upgrade == null) {
            return false;
        }
        type.put(upgrade, (type = this.upgrades.computeIfAbsent(upgrade.type(), k -> new HashMap())).containsKey(upgrade) ? (Integer)type.get(upgrade) + 1 : 1);
        return true;
    }

    public boolean removeBlock(class_1937 level, class_2248 block) {
        this.tryInitialise(level);
        AltarUpgrade upgrade = AltarUpgrade.get(level, block);
        if (upgrade == null) {
            return false;
        }
        Map<AltarUpgrade, Integer> type = this.upgrades.get(upgrade.type());
        if (type != null && type.containsKey(upgrade)) {
            int count = type.get(upgrade);
            if (count <= 1) {
                type.remove(upgrade);
            } else {
                type.put(upgrade, count - 1);
            }
        }
        return true;
    }

    public double calculatePowerMultiplier(class_1937 level) {
        this.tryInitialise(level);
        double multiplier = 1.0;
        for (class_2960 type : this.upgrades.keySet()) {
            AltarUpgrade highest = null;
            for (AltarUpgrade upgrade : this.upgrades.get(type).keySet()) {
                if (highest != null && highest.priority() >= upgrade.priority()) continue;
                highest = upgrade;
            }
            if (highest == null) continue;
            multiplier += highest.power();
        }
        return multiplier;
    }

    public double calculateRechargeMultiplier(class_1937 level) {
        this.tryInitialise(level);
        double multiplier = 1.0;
        for (class_2960 type : this.upgrades.keySet()) {
            AltarUpgrade highest = null;
            for (AltarUpgrade upgrade : this.upgrades.get(type).keySet()) {
                if (highest != null && highest.priority() >= upgrade.priority()) continue;
                highest = upgrade;
            }
            if (highest == null) continue;
            multiplier += highest.recharge();
        }
        return multiplier;
    }

    public void reset() {
        this.loadData.clear();
        this.upgrades.clear();
    }

    public class_2487 save(class_1937 level) {
        class_2487 nbt = new class_2487();
        level.method_30349().method_33310(EData.ALTAR_UPGRADE_REGISTRY).ifPresent(registry -> {
            for (Map<AltarUpgrade, Integer> typeMap : this.upgrades.values()) {
                for (Map.Entry<AltarUpgrade, Integer> entry : typeMap.entrySet()) {
                    nbt.method_10569(registry.method_10221((Object)entry.getKey()).toString(), entry.getValue().intValue());
                }
            }
        });
        return nbt;
    }

    public void load(class_2487 nbt) {
        for (String key : nbt.method_10541()) {
            this.loadData.put(new class_2960(key), nbt.method_10550(key));
        }
        this.isInitialised = false;
    }

    private void tryInitialise(class_1937 level) {
        if (!this.isInitialised) {
            this.upgrades.clear();
            level.method_30349().method_33310(EData.ALTAR_UPGRADE_REGISTRY).ifPresent(registry -> {
                for (Map.Entry<class_2960, Integer> entry : this.loadData.entrySet()) {
                    AltarUpgrade upgrade;
                    if (entry.getValue() == 0 || (upgrade = (AltarUpgrade)registry.method_10223(entry.getKey())) == null) continue;
                    class_2960 type = upgrade.type();
                    Map typeMap = this.upgrades.computeIfAbsent(type, a -> new HashMap());
                    typeMap.put(upgrade, entry.getValue());
                }
                this.isInitialised = true;
            });
        }
    }
}

