/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import javax.annotation.Nullable;
import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.api.power.IPowerProvider;
import net.favouriteless.enchanted.common.CommonConfig;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.altar.AltarBlockData;
import net.favouriteless.enchanted.common.altar.AltarStateObserver;
import net.favouriteless.enchanted.common.altar.AltarUpgradeData;
import net.favouriteless.enchanted.common.blocks.altar.AltarBlock;
import net.favouriteless.enchanted.common.init.registry.EnchantedBlockEntityTypes;
import net.favouriteless.enchanted.common.menus.AltarMenu;
import net.favouriteless.stateobserver.api.StateObserver;
import net.favouriteless.stateobserver.api.StateObserverManager;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;

public class AltarBlockEntity
extends class_2586
implements class_3908,
IPowerProvider {
    private final double rechargeRate;
    private final AltarBlockData altarBlockData;
    private final AltarUpgradeData altarUpgradeData;
    private double rechargeMultiplier;
    private double powerMultiplier;
    private double maxPower;
    private double currentPower;
    private final class_3913 fields;
    private AltarStateObserver stateObserver;
    private boolean facingX;
    private class_243 centerPos;
    private boolean firstLoad;
    private int ticksAlive;
    private boolean firstTick;

    public AltarBlockEntity(class_2338 pos, class_2680 state) {
        super(EnchantedBlockEntityTypes.ALTAR.get(), pos, state);
        this.rechargeRate = (Double)CommonConfig.INSTANCE.altarBaseRecharge.get();
        this.altarBlockData = new AltarBlockData();
        this.altarUpgradeData = new AltarUpgradeData();
        this.rechargeMultiplier = 1.0;
        this.powerMultiplier = 1.0;
        this.fields = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> (int)Math.round(AltarBlockEntity.this.currentPower);
                    case 1 -> (int)Math.round(AltarBlockEntity.this.maxPower);
                    case 2 -> (int)Math.round(AltarBlockEntity.this.rechargeMultiplier);
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        AltarBlockEntity.this.currentPower = value;
                    }
                    case 1: {
                        AltarBlockEntity.this.maxPower = value;
                    }
                    case 2: {
                        AltarBlockEntity.this.rechargeMultiplier = value;
                    }
                }
            }

            public int method_17389() {
                return 3;
            }
        };
        this.stateObserver = null;
        this.firstLoad = true;
        this.ticksAlive = 0;
        this.firstTick = true;
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, T t) {
        if (t instanceof AltarBlockEntity) {
            AltarBlockEntity be = (AltarBlockEntity)t;
            if (level != null && !level.field_9236) {
                if (be.firstTick) {
                    be.firstTick();
                }
                if (be.ticksAlive % 20 == 0) {
                    be.stateObserver.checkChanges();
                }
                if (be.currentPower <= be.maxPower) {
                    be.currentPower += be.rechargeRate * be.rechargeMultiplier;
                }
                if (be.currentPower > be.maxPower) {
                    be.currentPower = be.maxPower;
                }
                ++be.ticksAlive;
            }
        }
    }

    public void firstTick() {
        if (this.stateObserver == null) {
            this.stateObserver = (AltarStateObserver)StateObserverManager.get().getObserver(this.field_11863, this.field_11867, AltarStateObserver.class);
        }
        if (this.stateObserver == null) {
            int range = (Integer)CommonConfig.INSTANCE.altarRange.get();
            this.stateObserver = (AltarStateObserver)StateObserverManager.get().addObserver((StateObserver)new AltarStateObserver(this.field_11863, this.field_11867, range + 4, range + 4, range + 4));
        }
        this.facingX = (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AltarBlock.FACING_X);
        class_243 class_2432 = this.centerPos = this.facingX ? class_243.method_24954((class_2382)this.field_11867).method_1031(1.0, 0.0, 0.5) : class_243.method_24954((class_2382)this.field_11867).method_1031(0.5, 0.0, 1.0);
        if (this.firstLoad) {
            this.recalculateAll();
        }
        this.firstTick = false;
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10549("currentPower", this.currentPower);
        nbt.method_10549("maxPower", this.maxPower);
        nbt.method_10549("powerMultiplier", this.powerMultiplier);
        nbt.method_10549("rechargeMultiplier", this.rechargeMultiplier);
        nbt.method_10566("blockData", (class_2520)this.altarBlockData.save());
        nbt.method_10566("upgradeData", (class_2520)this.altarUpgradeData.save(this.field_11863));
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.setMaxPower(nbt.method_10574("maxPower"));
        this.setMaxPower(nbt.method_10574("maxPower"));
        this.currentPower = nbt.method_10574("currentPower");
        this.powerMultiplier = nbt.method_10574("powerMultiplier");
        this.rechargeMultiplier = nbt.method_10574("rechargeMultiplier");
        if (nbt.method_10545("blockData") && nbt.method_10545("upgradeData")) {
            this.altarBlockData.load(nbt.method_10562("blockData"));
            this.altarUpgradeData.load(nbt.method_10562("upgradeData"));
        } else {
            Enchanted.LOG.info(String.format("Failed to load power block data for altar at x:%s y:%s z:%s", this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()));
        }
        this.firstLoad = false;
    }

    private void recalculateAll() {
        this.recalculateUpgrades();
        this.recalculateBlocks();
    }

    private void recalculateUpgrades() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            class_2338 minPos = this.field_11867.method_10084();
            class_2338 maxPos = this.facingX ? minPos.method_10069(2, 0, 1) : minPos.method_10069(1, 0, 2);
            this.altarUpgradeData.reset();
            for (class_2338 pos : class_2338.method_10097((class_2338)minPos, (class_2338)maxPos)) {
                this.altarUpgradeData.addBlock(this.field_11863, this.field_11863.method_8320(pos).method_26204());
            }
            this.powerMultiplier = this.altarUpgradeData.calculatePowerMultiplier(this.field_11863);
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier(this.field_11863);
            this.method_5431();
        }
    }

    private void recalculateBlocks() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            int range = (Integer)CommonConfig.INSTANCE.altarRange.get();
            class_2338 startingPos = this.facingX ? class_2338.method_49638((class_2374)this.centerPos.method_1031((double)(-(range + 4)), (double)(-(range + 2)), (double)(-(range + 2)))) : class_2338.method_49638((class_2374)this.centerPos.method_1031((double)(-(range + 2)), (double)(-(range + 2)), (double)(-(range + 4))));
            this.altarBlockData.reset();
            for (int x = 0; x < (range + 2) * 2; ++x) {
                for (int y = 0; y < (range + 2) * 2; ++y) {
                    for (int z = 0; z < (range + 2) * 2; ++z) {
                        class_2338 currentPos = startingPos.method_10069(x, y, z);
                        if (!this.posWithinRange(currentPos, range)) continue;
                        class_2586 class_25862 = this.field_11863.method_8321(currentPos);
                        if (class_25862 instanceof IPowerConsumer) {
                            IPowerConsumer consumer = (IPowerConsumer)class_25862;
                            consumer.getPosHolder().add(this.field_11867);
                        }
                        this.addBlock(this.field_11863.method_8320(currentPos).method_26204());
                    }
                }
            }
        }
    }

    public boolean posWithinRange(class_2338 pos, int range) {
        if (this.field_11863 != null) {
            double rx = this.facingX ? (double)(range + 1) : (double)range;
            double rz = this.facingX ? (double)range : (double)(range + 1);
            double dx = (double)pos.method_10263() - this.centerPos.field_1352;
            double dy = (double)pos.method_10264() - this.centerPos.field_1351;
            double dz = (double)pos.method_10260() - this.centerPos.field_1350;
            return dx * dx / (rx * rx) + dy * dy / (double)(range * range) + dz * dz / (rz * rz) <= 1.0;
        }
        return false;
    }

    public boolean posIsUpgrade(class_2338 pos) {
        if (this.field_11863 != null) {
            int zMax;
            int xMax;
            if (this.facingX) {
                xMax = 2;
                zMax = 1;
            } else {
                xMax = 1;
                zMax = 2;
            }
            int xOffset = pos.method_10263() - this.field_11867.method_10263();
            int zOffset = pos.method_10260() - this.field_11867.method_10260();
            boolean withinX = xOffset >= 0 && xOffset <= xMax;
            boolean withinZ = zOffset >= 0 && zOffset <= zMax;
            return pos.method_10264() == this.field_11867.method_10264() + 1 && withinX && withinZ;
        }
        return false;
    }

    public void setMaxPower(double power) {
        this.maxPower = power;
        if (this.currentPower > this.maxPower) {
            this.currentPower = this.maxPower;
        }
        this.method_5431();
    }

    public void addBlock(class_2248 block) {
        this.setMaxPower(this.maxPower + (double)this.altarBlockData.addBlock(this.field_11863, block) * this.powerMultiplier);
        this.method_5431();
    }

    public void removeBlock(class_2248 block) {
        this.setMaxPower(this.maxPower - (double)this.altarBlockData.removeBlock(this.field_11863, block) * this.powerMultiplier);
        this.method_5431();
    }

    public void addUpgrade(class_2248 block) {
        if (this.altarUpgradeData.addBlock(this.field_11863, block)) {
            double newPowerMultiplier = this.altarUpgradeData.calculatePowerMultiplier(this.field_11863);
            if (newPowerMultiplier != this.powerMultiplier) {
                this.powerMultiplier = newPowerMultiplier;
                this.setMaxPower(this.altarBlockData.calculatePower(this.field_11863, this.powerMultiplier));
            }
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier(this.field_11863);
            this.method_5431();
        }
    }

    public void removeUpgrade(class_2248 block) {
        if (this.altarUpgradeData.removeBlock(this.field_11863, block)) {
            double newPowerMultiplier = this.altarUpgradeData.calculatePowerMultiplier(this.field_11863);
            if (newPowerMultiplier != this.powerMultiplier) {
                this.powerMultiplier = newPowerMultiplier;
                this.setMaxPower(this.altarBlockData.calculatePower(this.field_11863, this.powerMultiplier));
            }
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier(this.field_11863);
            this.method_5431();
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.enchanted.altar");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new AltarMenu(id, this, this.fields);
    }

    @Override
    public boolean tryConsume(double amount) {
        if (this.currentPower > amount) {
            this.currentPower -= amount;
            return true;
        }
        return false;
    }
}

