/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.api.power.IPowerProvider;
import net.favouriteless.enchanted.api.power.PowerHelper;
import net.favouriteless.enchanted.common.CommonConfig;
import net.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import net.favouriteless.enchanted.common.circle_magic.RiteManager;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.init.registry.EnchantedBlockEntityTypes;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GoldChalkBlockEntity
extends class_2586
implements IPowerConsumer {
    private final SimplePowerPosHolder posHolder;
    private boolean isExecuting;
    private boolean isInitialising = false;
    private RiteType type;
    private List<class_1799> itemsToConsume;
    private List<class_1299<?>> entitiesToConsume;
    private UUID caster;
    private List<class_1799> itemsConsumed = new ArrayList<class_1799>();

    public GoldChalkBlockEntity(class_2338 pos, class_2680 state) {
        super(EnchantedBlockEntityTypes.GOLD_CHALK.get(), pos, state);
        this.posHolder = new SimplePowerPosHolder(pos);
    }

    public void use(class_1937 level, class_2338 pos, class_1657 player) {
        if (!level.field_9236) {
            if (this.isExecuting) {
                Rite rite = RiteManager.getRiteAt((class_3218)level, this.field_11867);
                if (rite != null) {
                    rite.stop();
                    RiteManager.removeRite((class_3218)level, rite);
                } else {
                    this.detatch();
                }
            } else if (!this.isInitialising) {
                this.type = RiteType.getFirstMatching(level, pos);
                if (this.type != null) {
                    class_2960 key = level.method_30349().method_30530(EData.RITE_TYPES_REGISTRY).method_10221((Object)this.type);
                    if (key == null || ((List)CommonConfig.INSTANCE.disabledRites.get()).contains(key.toString())) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"This rite has been disabled in the config.").method_27692(class_124.field_1061), false);
                        level.method_8396(null, this.field_11867, (class_3414)class_3417.field_14708.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
                        this.type = null;
                        return;
                    }
                    this.itemsToConsume = this.type.getItems();
                    this.entitiesToConsume = this.type.getEntities();
                    this.caster = player.method_5667();
                    this.isInitialising = true;
                } else {
                    level.method_8396(null, this.field_11867, (class_3414)class_3417.field_14708.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
                }
            }
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, GoldChalkBlockEntity be) {
        if (!be.isInitialising) {
            if (be.isExecuting) {
                be.createExecutingParticles();
            }
        } else {
            be.createExecutingParticles();
            if (level.method_8510() % 20L != 0L) {
                return;
            }
            be.itemsToConsume.removeIf(class_1799::method_7960);
            if (!be.isDoneConsuming()) {
                if (!be.tryConsumeNext() && !be.isDoneConsuming()) {
                    be.cancel();
                }
            } else {
                IPowerProvider provider = PowerHelper.tryGetPowerProvider(level, be.posHolder);
                int power = be.type.getPower();
                if (power == 0 || provider != null && provider.tryConsume(power)) {
                    be.isExecuting = true;
                    be.isInitialising = false;
                    Rite rite = be.type.create((class_3218)level, be.field_11867, be.caster, be.itemsConsumed);
                    be.itemsConsumed = new ArrayList<class_1799>();
                    RiteManager.addRite((class_3218)level, rite);
                    rite.start();
                } else {
                    be.cancel();
                }
            }
        }
        GoldChalkBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
    }

    protected void createExecutingParticles() {
        double dx = (double)this.field_11867.method_10263() + Math.random();
        double dy = (double)this.field_11867.method_10264() + Math.random() * 0.3;
        double dz = (double)this.field_11867.method_10260() + Math.random();
        ((class_3218)this.field_11863).method_14199((class_2394)new class_2390(new Vector3f(0.99607843f, 0.36862746f, 0.36862746f), 1.0f), dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
    }

    protected boolean isDoneConsuming() {
        return this.itemsToConsume.isEmpty() && this.entitiesToConsume.isEmpty();
    }

    public void detatch() {
        this.isExecuting = false;
        this.type = null;
        this.isInitialising = false;
    }

    protected void cancel() {
        this.isExecuting = false;
        this.isInitialising = false;
        this.type = null;
        this.itemsToConsume = null;
        this.entitiesToConsume = null;
        if (!this.field_11863.field_9236) {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)class_3417.field_14708.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
            for (class_1799 stack : this.itemsConsumed) {
                class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, stack);
                this.field_11863.method_8649((class_1297)entity);
            }
        }
        this.itemsConsumed.clear();
    }

    protected boolean tryConsumeNext() {
        if (this.tryConsumeItem()) {
            return true;
        }
        return this.tryConsumeEntity();
    }

    protected boolean tryConsumeItem() {
        List entities = this.field_11863.method_18467(class_1542.class, new class_238((double)(this.field_11867.method_10263() - 3), (double)this.field_11867.method_10264(), (double)(this.field_11867.method_10260() - 3), (double)(this.field_11867.method_10263() + 4), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 4)));
        for (class_1542 entity : entities) {
            class_1799 item = entity.method_6983();
            for (class_1799 required : this.itemsToConsume) {
                if (!ItemUtils.isSameItemPartial(item, required)) continue;
                this.createConsumeEffect((class_1297)entity);
                int toConsume = Math.min(required.method_7947(), item.method_7947());
                if (!entity.method_6983().method_31574(EItems.ATTUNED_STONE_CHARGED.get())) {
                    class_1799 copy = item.method_7972();
                    copy.method_7939(toConsume);
                    this.itemsConsumed.add(copy);
                    item.method_7934(toConsume);
                    if (item.method_7960()) {
                        entity.method_31472();
                    }
                } else {
                    entity.method_6979(new class_1799((class_1935)EItems.ATTUNED_STONE.get(), toConsume));
                }
                required.method_7934(toConsume);
                return true;
            }
        }
        return false;
    }

    protected boolean tryConsumeEntity() {
        List entities = this.field_11863.method_8335(null, new class_238((double)(this.field_11867.method_10263() - 3), (double)this.field_11867.method_10264(), (double)(this.field_11867.method_10260() - 3), (double)(this.field_11867.method_10263() + 4), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 4)));
        for (class_1297 entity : entities) {
            if (!this.entitiesToConsume.remove(entity.method_5864())) continue;
            entity.method_5768();
            return true;
        }
        return false;
    }

    protected void createConsumeEffect(class_1297 entity) {
        if (!this.field_11863.field_9236) {
            this.field_11863.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15219, class_3419.field_15250, 1.0f, 1.0f);
            ((class_3218)this.field_11863).method_14199((class_2394)class_2398.field_11204, entity.method_23317(), entity.method_23318(), entity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void method_11007(class_2487 tag) {
        tag.method_10566("posHolder", (class_2520)this.posHolder.serialize());
        tag.method_10556("isExecuting", this.isExecuting);
    }

    public void method_11014(class_2487 tag) {
        this.posHolder.deserialize(tag.method_10562("posHolder"));
        this.isExecuting = tag.method_10577("isExecuting");
    }

    public boolean tryConsumePower(int amount) {
        IPowerProvider provider = PowerHelper.tryGetPowerProvider(this.field_11863, this.posHolder);
        return amount == 0 || provider != null && provider.tryConsume(amount);
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }
}

