/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import javax.annotation.Nullable;
import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.api.power.IPowerProvider;
import net.favouriteless.enchanted.api.power.PowerHelper;
import net.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import net.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import net.favouriteless.enchanted.common.init.registry.ERecipeTypes;
import net.favouriteless.enchanted.common.init.registry.EnchantedBlockEntityTypes;
import net.favouriteless.enchanted.common.menus.SpinningWheelMenu;
import net.favouriteless.enchanted.common.recipes.SpinningRecipe;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;

public class SpinningWheelBlockEntity
extends ContainerBlockEntityBase
implements IPowerConsumer,
class_3908,
class_1278 {
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2};
    private static final int[] BOTTOM_SLOTS = new int[]{3};
    private final class_1863.class_7266<class_1263, SpinningRecipe> recipeCheck;
    private final SimplePowerPosHolder posHolder;
    private boolean isSpinning = false;
    private int spinDuration = 300;
    private int spinProgress = 0;
    public class_3913 data = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> SpinningWheelBlockEntity.this.spinProgress;
                case 1 -> SpinningWheelBlockEntity.this.spinDuration;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                SpinningWheelBlockEntity.this.spinProgress = value;
            } else if (index == 2) {
                SpinningWheelBlockEntity.this.spinDuration = value;
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public SpinningWheelBlockEntity(class_2338 pos, class_2680 state) {
        super(EnchantedBlockEntityTypes.SPINNING_WHEEL.get(), pos, state, (class_2371<class_1799>)class_2371.method_10213((int)4, (Object)class_1799.field_8037));
        this.posHolder = new SimplePowerPosHolder(pos);
        this.recipeCheck = class_1863.method_42302(ERecipeTypes.SPINNING.get());
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, T t) {
        if (t instanceof SpinningWheelBlockEntity) {
            SpinningWheelBlockEntity be = (SpinningWheelBlockEntity)t;
            if (!level.field_9236) {
                boolean wasSpinning;
                IPowerProvider powerProvider = PowerHelper.tryGetPowerProvider(level, be.posHolder);
                SpinningRecipe recipe = be.recipeCheck.method_42303((class_1263)be, level).orElse(null);
                boolean bl = wasSpinning = be.spinProgress > 0;
                if (be.canSpin(recipe) && (recipe.getPower() == 0 || powerProvider != null && powerProvider.tryConsume((double)recipe.getPower() / (double)be.spinDuration))) {
                    if (++be.spinProgress == be.spinDuration) {
                        be.spinProgress = 0;
                        be.spinDuration = recipe.getDuration();
                        be.spin(recipe);
                    }
                } else {
                    be.spinProgress = 0;
                }
                if (wasSpinning != be.spinProgress > 0) {
                    be.updateBlock();
                }
            } else {
                be.spinProgress = be.isSpinning ? ++be.spinProgress : 0;
            }
        }
    }

    protected void spin(SpinningRecipe recipe) {
        block0: for (class_1799 recipeStack : recipe.getItemsIn()) {
            for (int i = 0; i < 3; ++i) {
                class_1799 input = (class_1799)this.inventory.get(i);
                if (!ItemUtils.isSameItemPartial(recipeStack, input)) continue;
                input.method_7934(recipeStack.method_7947());
                continue block0;
            }
        }
        class_1799 result = recipe.method_8116(this, this.field_11863.method_30349());
        class_1799 output = (class_1799)this.inventory.get(3);
        if (output.method_7960()) {
            this.inventory.set(3, (Object)result);
        } else {
            output.method_7933(result.method_7947());
        }
    }

    protected boolean canSpin(SpinningRecipe recipe) {
        if (recipe != null) {
            class_1799 output = (class_1799)this.inventory.get(3);
            if (output.method_7960()) {
                return true;
            }
            class_1799 result = recipe.method_8116(this, this.field_11863.method_30349());
            if (class_1799.method_31577((class_1799)result, (class_1799)output)) {
                return output.method_7947() + result.method_7947() <= output.method_7914();
            }
        }
        return false;
    }

    @Override
    @NotNull
    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.enchanted.spinning_wheel");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new SpinningWheelMenu(id, playerInventory, this, this.data);
    }

    @Override
    public void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("posHolder", (class_2520)this.posHolder.serialize());
        nbt.method_10569("spinProgress", this.spinProgress);
        nbt.method_10569("spinDuration", this.spinDuration);
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("posHolder")) {
            this.posHolder.deserialize(nbt.method_10562("posHolder"));
        }
        if (nbt.method_10545("spinProgress")) {
            this.spinProgress = nbt.method_10550("spinProgress");
        }
        if (nbt.method_10545("isSpinning")) {
            this.isSpinning = nbt.method_10577("isSpinning");
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        nbt.method_10556("isSpinning", this.spinProgress > 0);
        return nbt;
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }

    public int getSpinProgress() {
        return this.spinProgress;
    }

    public int[] method_5494(@NotNull class_2350 face) {
        if (face == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        return INPUT_SLOTS;
    }

    public boolean method_5492(int index, @NotNull class_1799 stack, @Nullable class_2350 face) {
        return index != 3;
    }

    public boolean method_5493(int index, @NotNull class_1799 stack, @Nullable class_2350 face) {
        return true;
    }
}

