/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.FumeFunnelBlock;
import net.favouriteless.enchanted.common.blocks.WitchOvenBlock;
import net.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import net.favouriteless.enchanted.common.init.EnchantedTags;
import net.favouriteless.enchanted.common.init.registry.EBlocks;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.init.registry.ERecipeTypes;
import net.favouriteless.enchanted.common.init.registry.EnchantedBlockEntityTypes;
import net.favouriteless.enchanted.common.menus.WitchOvenMenu;
import net.favouriteless.enchanted.common.recipes.ByproductRecipe;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3861;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WitchOvenBlockEntity
extends ContainerBlockEntityBase
implements class_3908,
class_1278 {
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] SIDE_SLOTS = new int[]{1};
    private static final int[] FACE_SLOTS = new int[]{2};
    private static final int[] BOTTOM_SLOTS = new int[]{3, 4};
    private final class_1863.class_7266<class_1263, class_3861> smeltCheck;
    private final class_1863.class_7266<class_1263, ByproductRecipe> ovenCheck;
    private int burnProgress = 0;
    private int burnDuration = 0;
    private int cookProgress = 0;
    private int cookDuration = 200;
    private final class_3913 data = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> WitchOvenBlockEntity.this.burnProgress;
                case 1 -> WitchOvenBlockEntity.this.burnDuration;
                case 2 -> WitchOvenBlockEntity.this.cookProgress;
                case 3 -> WitchOvenBlockEntity.this.cookDuration;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    WitchOvenBlockEntity.this.burnProgress = value;
                }
                case 1: {
                    WitchOvenBlockEntity.this.burnDuration = value;
                }
                case 2: {
                    WitchOvenBlockEntity.this.cookProgress = value;
                }
                case 3: {
                    WitchOvenBlockEntity.this.cookDuration = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public WitchOvenBlockEntity(class_2338 pos, class_2680 state) {
        super(EnchantedBlockEntityTypes.WITCH_OVEN.get(), pos, state, (class_2371<class_1799>)class_2371.method_10213((int)5, (Object)class_1799.field_8037));
        this.smeltCheck = class_1863.method_42302((class_3956)class_3956.field_17546);
        this.ovenCheck = class_1863.method_42302(ERecipeTypes.BYPRODUCT.get());
    }

    public static <T extends class_2586> void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, T t) {
        if (t instanceof WitchOvenBlockEntity) {
            boolean hasInput;
            class_1799 fuelStack;
            WitchOvenBlockEntity be = (WitchOvenBlockEntity)t;
            boolean startedBurning = be.isLit();
            boolean isChanged = false;
            if (be.isLit()) {
                --be.burnProgress;
            }
            boolean hasFuel = !(fuelStack = be.getFuel()).method_7960();
            boolean bl = hasInput = !be.getInput().method_7960();
            if (be.isLit() || hasInput && hasFuel) {
                class_1860 recipe;
                class_1860 class_18602 = recipe = hasInput ? (class_1860)be.smeltCheck.method_42303((class_1263)be, level).orElse(null) : null;
                if (!be.isLit() && be.canBurn(recipe)) {
                    be.burnDuration = be.burnProgress = CommonServices.PLATFORM.getBurnTime(fuelStack, class_3956.field_17546);
                    if (be.isLit()) {
                        isChanged = true;
                        if (CommonServices.PLATFORM.hasCraftingRemainingItem(fuelStack)) {
                            be.inventory.set(2, (Object)CommonServices.PLATFORM.getCraftingRemainingItem(fuelStack));
                        } else if (hasFuel) {
                            fuelStack.method_7934(1);
                            class_1799 remainder = CommonServices.PLATFORM.getCraftingRemainingItem(fuelStack);
                            if (fuelStack.method_7960()) {
                                be.inventory.set(2, (Object)(remainder == null ? class_1799.field_8037 : remainder));
                            }
                        }
                    }
                }
                if (be.isLit() && be.canBurn(recipe)) {
                    if (++be.cookProgress == be.cookDuration) {
                        be.cookProgress = 0;
                        be.cookDuration = WitchOvenBlockEntity.getTotalCookTime(level, be);
                        be.burn(recipe);
                        isChanged = true;
                    }
                } else {
                    be.cookProgress = 0;
                }
            } else if (!be.isLit() && be.cookProgress > 0) {
                be.cookProgress = class_3532.method_15340((int)(be.cookProgress - 2), (int)0, (int)be.cookDuration);
            }
            if (startedBurning != be.isLit()) {
                isChanged = true;
                level.method_8652(be.field_11867, (class_2680)level.method_8320(be.field_11867).method_11657((class_2769)WitchOvenBlock.LIT, (Comparable)Boolean.valueOf(be.isLit())), 3);
                be.updateFumeFunnels();
            }
            if (isChanged) {
                be.method_5431();
            }
        }
    }

    private void burn(@Nullable class_1860<?> recipe) {
        if (this.canBurn(recipe)) {
            class_1799 input = this.getInput();
            class_1799 fuel = this.getFuel();
            class_1799 result = recipe.method_8110(this.field_11863.method_30349());
            class_1799 output = this.getOutput();
            if (Enchanted.RANDOM.nextDouble() <= this.getByproductChance()) {
                this.tryCreateByproduct(this.ovenCheck.method_42303((class_1263)this, this.field_11863).orElse(null));
            }
            if (output.method_7960()) {
                this.inventory.set(3, (Object)result.method_7972());
            } else {
                output.method_7933(1);
            }
            if (input.method_31574(class_2246.field_10562.method_8389()) && !fuel.method_7960() && fuel.method_31574(class_1802.field_8550)) {
                this.inventory.set(2, (Object)new class_1799((class_1935)class_1802.field_8705));
            }
            input.method_7934(1);
        }
    }

    private boolean canBurn(@Nullable class_1860<?> recipe) {
        class_1799 input = this.getInput();
        if (recipe != null && !input.method_31573(EnchantedTags.Items.WITCH_OVEN_BLACKLIST)) {
            class_1799 result = recipe.method_8116((class_1263)this, this.field_11863.method_30349());
            if (result.method_7960()) {
                return false;
            }
            class_1799 output = this.getOutput();
            if (output.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)output, (class_1799)result)) {
                return false;
            }
            return output.method_7947() + result.method_7947() <= output.method_7914();
        }
        return false;
    }

    private void tryCreateByproduct(@Nullable ByproductRecipe recipe) {
        class_1799 jars;
        class_1799 result;
        if (recipe != null && !this.getInput().method_7960() && !(result = recipe.method_8116(this, this.field_11863.method_30349())).method_7960() && (jars = this.getJarInput()).method_7947() >= result.method_7947()) {
            class_1799 output = this.getJarOutput();
            if (output.method_7960()) {
                this.inventory.set(4, (Object)result);
            } else if (class_1799.method_31577((class_1799)output, (class_1799)result) && output.method_7947() + result.method_7947() <= output.method_7914()) {
                output.method_7933(result.method_7947());
            }
            jars.method_7934(result.method_7947());
        }
    }

    private void updateFumeFunnels() {
        if (!this.field_11863.field_9236) {
            class_2338[] potentialFilters;
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            class_2350 facing = (class_2350)state.method_11654((class_2769)WitchOvenBlock.FACING);
            for (class_2338 _pos : potentialFilters = new class_2338[]{new class_2338((class_2382)this.field_11867.method_10081(facing.method_10170().method_10163())), new class_2338((class_2382)this.field_11867.method_10081(facing.method_10160().method_10163())), new class_2338((class_2382)this.field_11867.method_10081(class_2350.field_11036.method_10163()))}) {
                if (!(this.field_11863.method_8320(_pos).method_26204() instanceof FumeFunnelBlock)) continue;
                this.field_11863.method_8652(_pos, (class_2680)this.field_11863.method_8320(_pos).method_11657((class_2769)class_2363.field_11105, (Comparable)Boolean.valueOf(this.isLit())), 3);
            }
        }
    }

    private double getByproductChance() {
        class_2248[] potentialFilters;
        double byproductChance = 0.3;
        class_2350 facing = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)WitchOvenBlock.FACING);
        for (class_2248 block : potentialFilters = new class_2248[]{this.field_11863.method_8320(this.field_11867.method_10081(facing.method_10170().method_10163())).method_26204(), this.field_11863.method_8320(this.field_11867.method_10081(facing.method_10160().method_10163())).method_26204()}) {
            if (block == EBlocks.FUME_FUNNEL.get()) {
                byproductChance += 0.2;
                continue;
            }
            if (block != EBlocks.FUME_FUNNEL_FILTERED.get()) continue;
            byproductChance += 0.35;
        }
        return byproductChance;
    }

    private static int getTotalCookTime(class_1937 level, WitchOvenBlockEntity be) {
        return be.smeltCheck.method_42303((class_1263)be, level).map(recipe -> Math.round((float)recipe.method_8167() * 0.8f)).orElse(200);
    }

    public class_1799 getInput() {
        return (class_1799)this.inventory.get(0);
    }

    public class_1799 getJarInput() {
        return (class_1799)this.inventory.get(1);
    }

    public class_1799 getFuel() {
        return (class_1799)this.inventory.get(2);
    }

    public class_1799 getOutput() {
        return (class_1799)this.inventory.get(3);
    }

    public class_1799 getJarOutput() {
        return (class_1799)this.inventory.get(4);
    }

    @Override
    @NotNull
    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.enchanted.witch_oven");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new WitchOvenMenu(id, playerInventory, this, this.data);
    }

    @Override
    public void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("burnTime", this.burnProgress);
        nbt.method_10569("burnTimeTotal", this.burnDuration);
        nbt.method_10569("cookTime", this.cookProgress);
        nbt.method_10569("cookTimeTotal", this.cookDuration);
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.burnProgress = nbt.method_10550("burnTime");
        this.burnDuration = nbt.method_10550("burnTimeTotal");
        this.cookProgress = nbt.method_10550("cookTime");
        this.cookDuration = nbt.method_10550("cookTimeTotal");
    }

    private boolean isLit() {
        return this.burnProgress > 0;
    }

    public int[] method_5494(@NotNull class_2350 face) {
        if (face == class_2350.field_11036) {
            return TOP_SLOTS;
        }
        if (face == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        if (face.method_10166() == ((class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)WitchOvenBlock.FACING)).method_10166()) {
            return FACE_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public boolean method_5492(int index, @NotNull class_1799 stack, @Nullable class_2350 face) {
        if (index == 1) {
            return stack.method_7909() == EItems.CLAY_JAR.get();
        }
        return index != 3 && index != 4;
    }

    public boolean method_5493(int index, @NotNull class_1799 stack, @Nullable class_2350 face) {
        if (face == class_2350.field_11033 && index == 1) {
            return stack.method_31574(class_1802.field_8705) || stack.method_31574(class_1802.field_8550);
        }
        return true;
    }

    @Override
    public void method_5447(int index, @NotNull class_1799 stack) {
        boolean matching = !stack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)this.getInput());
        this.inventory.set(index, (Object)stack);
        if (index == 0 && !matching) {
            this.cookDuration = WitchOvenBlockEntity.getTotalCookTime(this.field_11863, this);
            this.cookProgress = 0;
            this.method_5431();
        }
    }
}

