/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.favouriteless.enchanted.api.Vec2i;
import net.favouriteless.enchanted.common.init.registry.EBlocks;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4538;

public class CircleMagicShape {
    public static final Codec<CircleMagicShape> CODEC = Codec.STRING.listOf().xmap(CircleMagicShape::new, CircleMagicShape::getStrings);
    private final List<String> input;
    private final List<Vec2i> points = new ArrayList<Vec2i>();
    private final List<Vec2i> interiorPoints = new ArrayList<Vec2i>();
    private final int radius;

    public CircleMagicShape(List<String> rows) {
        this.input = rows;
        int width = rows.get(0).length();
        if (rows.size() != width) {
            throw new IllegalArgumentException("Circle magic shapes must be square");
        }
        if (width % 2 == 0) {
            throw new IllegalArgumentException("Circle magic shapes must have an odd width.");
        }
        for (String row : rows) {
            if (row.length() == width) continue;
            throw new IllegalArgumentException("All rows in a circle magic shape must be the same width.");
        }
        int radius = width / 2;
        boolean foundPoint = false;
        for (int y = 0; y < width; ++y) {
            String rowString = rows.get(y);
            if (!foundPoint && !rowString.isBlank()) {
                foundPoint = true;
            }
            for (int x = 0; x < width; ++x) {
                char charAt = rowString.charAt(x);
                if (charAt == 'X') {
                    this.points.add(new Vec2i(x - radius, y - radius));
                    continue;
                }
                if (charAt != 'O') continue;
                this.interiorPoints.add(new Vec2i(x - radius, y - radius));
            }
        }
        if (!foundPoint) {
            throw new IllegalArgumentException("A circle magic shape cannot have zero points");
        }
        this.radius = (width - 1) / 2;
    }

    public boolean matches(class_1937 level, class_2338 pos, class_2248 block) {
        for (Vec2i point : this.points) {
            class_2680 state = level.method_8320(pos.method_10069(point.x(), 0, point.y()));
            if (state.method_27852(block)) continue;
            return false;
        }
        return true;
    }

    public List<String> getStrings() {
        return this.input;
    }

    public List<Vec2i> getInteriorPoints() {
        return this.interiorPoints;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean canPlace(class_1937 level, class_2338 center) {
        for (Vec2i point : this.points) {
            class_2338 pos = center.method_10069(point.x(), 0, point.y());
            if (level.method_8320(pos).method_45474() && EBlocks.RITUAL_CHALK.get().method_9558(null, (class_4538)level, pos)) continue;
            return false;
        }
        return true;
    }

    public void place(class_1937 level, class_2338 center, class_2248 block, class_1838 context) {
        for (Vec2i point : this.points) {
            level.method_8501(center.method_10069(point.x(), 0, point.y()), block.method_9605(new class_1750(context)));
        }
    }

    public void remove(class_1937 level, class_2338 center) {
        for (Vec2i point : this.points) {
            level.method_8501(center.method_10069(point.x(), 0, point.y()), class_2246.field_10124.method_9564());
        }
    }

    public class_2248 getBlockAt(class_1937 level, class_2338 center) {
        Vec2i p1 = this.points.get(0);
        class_2680 first = level.method_8320(center.method_10069(p1.x(), 0, p1.y()));
        if (first.method_26215()) {
            return null;
        }
        for (int i = 1; i < this.points.size(); ++i) {
            Vec2i p = this.points.get(i);
            if (level.method_8320(center.method_10069(p.x(), 0, p.y())).method_27852(first.method_26204())) continue;
            return null;
        }
        return first.method_26204();
    }
}

