/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EData;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.slf4j.Logger;

public class RiteManager
extends class_18 {
    private static final String NAME = "enchanted_rites";
    private final List<Rite> activeRites = new ArrayList<Rite>();
    public final class_3218 level;

    public RiteManager(class_3218 level) {
        this.level = level;
    }

    public static RiteManager get(class_3218 level) {
        return (RiteManager)level.method_17983().method_17924(tag -> RiteManager.load(level, tag), () -> new RiteManager(level), NAME);
    }

    public static void addRite(class_3218 level, Rite rite) {
        RiteManager manager = RiteManager.get(level);
        manager.activeRites.add(rite);
        manager.method_80();
    }

    public static void removeRite(class_3218 level, Rite rite) {
        RiteManager manager = RiteManager.get(level);
        manager.activeRites.remove(rite);
        manager.method_80();
    }

    public static void tick(class_3218 level) {
        RiteManager manager = RiteManager.get(level);
        manager.activeRites.removeIf(rite -> !rite.tick());
        manager.method_80();
    }

    public static Rite getRiteAt(class_3218 level, class_2338 pos) {
        RiteManager manager = RiteManager.get(level);
        for (Rite rite : manager.activeRites) {
            if (!rite.getPos().equals((Object)pos)) continue;
            return rite;
        }
        return null;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2487 out = new class_2487();
        class_2499 riteList = new class_2499();
        class_2378 registry = this.level.method_30349().method_30530(EData.RITE_TYPES_REGISTRY);
        for (Rite rite : this.activeRites) {
            class_2960 typeId = registry.method_10221((Object)rite.getType());
            if (typeId == null) continue;
            class_2487 riteTag = rite.save();
            riteTag.method_10566("type", (class_2520)class_2960.field_25139.encodeStart((DynamicOps)class_2509.field_11560, (Object)typeId).getOrThrow(false, arg_0 -> ((Logger)Enchanted.LOG).error(arg_0)));
            riteTag.method_10566("pos", (class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, (Object)rite.getPos()).getOrThrow(false, arg_0 -> ((Logger)Enchanted.LOG).error(arg_0)));
            riteList.add((Object)riteTag);
        }
        out.method_10566("rites", (class_2520)riteList);
        return out;
    }

    public static RiteManager load(class_3218 level, class_2487 tag) {
        RiteManager manager = new RiteManager(level);
        class_2499 riteList = tag.method_10554("rites", 10);
        class_2378 registry = level.method_30349().method_30530(EData.RITE_TYPES_REGISTRY);
        for (int i = 0; i < riteList.size(); ++i) {
            try {
                class_2487 riteTag = riteList.method_10602(i);
                RiteType type = (RiteType)registry.method_10223((class_2960)class_2960.field_25139.parse((DynamicOps)class_2509.field_11560, (Object)riteTag.method_10580("type")).getOrThrow(false, arg_0 -> ((Logger)Enchanted.LOG).error(arg_0)));
                class_2338 pos = (class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, (Object)riteTag.method_10580("pos")).getOrThrow(false, arg_0 -> ((Logger)Enchanted.LOG).error(arg_0));
                Rite rite = type.create(level, pos);
                rite.load(riteTag);
                manager.activeRites.add(rite);
                continue;
            }
            catch (Exception e) {
                Enchanted.LOG.error("Failed to load Rite, skipping: {}", (Object)e.getMessage());
            }
        }
        return manager;
    }
}

