/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.favouriteless.enchanted.api.Vec2i;
import net.favouriteless.enchanted.api.rites.RiteFactory;
import net.favouriteless.enchanted.common.circle_magic.CircleMagicShape;
import net.favouriteless.enchanted.common.circle_magic.RiteFactoryRegistry;
import net.favouriteless.enchanted.common.circle_magic.RiteWeatherRequirement;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class RiteType
implements Comparable<RiteType> {
    public static final Codec<RiteType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.listOf().fieldOf("items").forGetter(r -> r.items), (App)Codec.unboundedMap((Codec)class_5321.method_39154(EData.CIRCLE_SHAPE_REGISTRY), (Codec)class_7923.field_41175.method_39673()).optionalFieldOf("shapes", Map.of()).forGetter(r -> r.shapes), (App)class_7923.field_41177.method_39673().listOf().optionalFieldOf("entities", List.of()).forGetter(r -> r.entities), (App)Codec.INT.optionalFieldOf("power", (Object)0).forGetter(r -> r.power), (App)Codec.INT.optionalFieldOf("tick_power", (Object)0).forGetter(r -> r.tickPower), (App)RiteWeatherRequirement.CODEC.optionalFieldOf("weather", (Object)RiteWeatherRequirement.NONE).forGetter(r -> r.weather), (App)Codec.INT.listOf().optionalFieldOf("time", List.of(Integer.valueOf(0), Integer.valueOf(24000))).forGetter(r -> r.timeRange), (App)RiteFactoryRegistry.CODEC.fieldOf("factory").forGetter(r -> r.factory)).apply((Applicative)instance, RiteType::new));
    private final List<class_1799> items;
    private final Map<class_5321<CircleMagicShape>, class_2248> shapes;
    private final List<class_1299<?>> entities;
    private final int power;
    private final int tickPower;
    private final RiteFactory factory;
    private final RiteWeatherRequirement weather;
    private final List<Integer> timeRange;
    private final List<Vec2i> interiorPoints = new ArrayList<Vec2i>();
    private int radius = 1;

    public RiteType(List<class_1799> items, Map<class_5321<CircleMagicShape>, class_2248> shapes, List<class_1299<?>> entities, int power, int tickPower, RiteWeatherRequirement weather, List<Integer> times, RiteFactory factory) {
        this.items = items;
        this.shapes = shapes;
        this.entities = entities;
        this.power = power;
        this.tickPower = tickPower;
        this.weather = weather;
        this.timeRange = times;
        this.factory = factory;
    }

    public boolean matches(class_1937 level, class_2338 pos, List<class_1297> inputs) {
        if (!this.weather.check(level)) {
            return false;
        }
        long time = level.method_8532() % 24000L;
        if (time < (long)this.timeRange.get(0).intValue()) {
            return false;
        }
        if (time > (long)this.timeRange.get(1).intValue()) {
            return false;
        }
        for (Map.Entry<class_5321<CircleMagicShape>, class_2248> entry : this.shapes.entrySet()) {
            CircleMagicShape shape = (CircleMagicShape)level.method_30349().method_30530(EData.CIRCLE_SHAPE_REGISTRY).method_29107(entry.getKey());
            if (shape.matches(level, pos, entry.getValue())) continue;
            return false;
        }
        List<class_1299<?>> entities = this.getEntities();
        inputs.forEach(entity -> entities.remove(entity.method_5864()));
        if (!entities.isEmpty()) {
            return false;
        }
        List<class_1799> items = this.getItems();
        for (class_1297 input : inputs) {
            if (!(input instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)input;
            class_1799 item = itemEntity.method_6983();
            if (item.method_7960()) break;
            for (class_1799 required : items) {
                if (!ItemUtils.isSameItemPartial(item, required)) continue;
                required.method_7934(item.method_7947());
            }
        }
        items.removeIf(class_1799::method_7960);
        return items.isEmpty();
    }

    public List<class_1799> getItems() {
        ArrayList<class_1799> returned = new ArrayList<class_1799>();
        this.items.forEach(i -> returned.add(i.method_7972()));
        return returned;
    }

    public List<class_1299<?>> getEntities() {
        return new ArrayList(this.entities);
    }

    public Map<class_5321<CircleMagicShape>, class_2248> getShapes() {
        return this.shapes;
    }

    public int getPower() {
        return this.power;
    }

    public int getRadius() {
        return this.radius;
    }

    public class_238 getBounds(class_2338 pos) {
        class_243 center = pos.method_46558().method_1023(0.0, 0.5, 0.0);
        return new class_238(center.method_1023((double)this.radius, 0.0, (double)this.radius), center.method_1031((double)this.radius, 1.0, (double)this.radius));
    }

    @Nullable
    public List<class_1799> getOutputs() {
        return this.factory.getOutputs();
    }

    public List<Vec2i> getInteriorPoints() {
        if (this.interiorPoints.isEmpty()) {
            this.shapes.keySet().forEach(shapeLoc -> {
                CircleMagicShape shape = (CircleMagicShape)class_310.method_1551().method_1562().method_29091().method_30530(EData.CIRCLE_SHAPE_REGISTRY).method_29107(shapeLoc);
                if (shape.getRadius() > this.radius) {
                    this.radius = shape.getRadius();
                }
                this.interiorPoints.addAll(shape.getInteriorPoints());
            });
        }
        return this.interiorPoints;
    }

    public Rite create(class_3218 level, class_2338 pos, UUID caster, List<class_1799> consumedItems) {
        return this.factory.create(new Rite.BaseRiteParams(this, level, pos, this.tickPower), Rite.RiteParams.of(caster, consumedItems));
    }

    public Rite create(class_3218 level, class_2338 pos) {
        return this.factory.create(new Rite.BaseRiteParams(this, level, pos, this.tickPower), Rite.RiteParams.empty());
    }

    public static RiteType getFirstMatching(class_1937 level, class_2338 pos) {
        class_2378 reg = level.method_30349().method_30530(EData.RITE_TYPES_REGISTRY);
        List entities = level.method_8335(null, new class_238((double)(pos.method_10263() - 3), (double)pos.method_10264(), (double)(pos.method_10260() - 3), (double)(pos.method_10263() + 4), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 4)));
        Iterator it = reg.method_10220().sorted().iterator();
        while (it.hasNext()) {
            RiteType type = (RiteType)it.next();
            if (!type.matches(level, pos, entities)) continue;
            return type;
        }
        return null;
    }

    @Override
    public int compareTo(@NotNull RiteType o) {
        if (this.shapes.size() == o.shapes.size() && this.items.size() == o.items.size() && this.entities.size() == o.entities.size()) {
            return 0;
        }
        if (this.shapes.size() > o.shapes.size()) {
            return -1;
        }
        if (this.shapes.size() < o.shapes.size()) {
            return 1;
        }
        if (this.items.size() > o.items.size()) {
            return -1;
        }
        if (this.items.size() < o.items.size()) {
            return 1;
        }
        if (this.entities.size() > o.entities.size()) {
            return -1;
        }
        return 1;
    }
}

