/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EnchantedTags;
import net.favouriteless.enchanted.common.init.registry.EParticleTypes;
import net.favouriteless.enchanted.common.util.BlockPosUtils;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class BlightRite
extends Rite {
    public static final int TICKS_PER_BLOCK = 3;
    protected final int radius;
    protected final int radiusSq;
    protected final double decayChance;
    protected final double zombieChance;
    protected int step = 1;

    public BlightRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, int radius, double decayChance, double zombieChance) {
        super(baseParams, params);
        this.radius = radius;
        this.radiusSq = radius * radius;
        this.decayChance = decayChance;
        this.zombieChance = zombieChance;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        class_1297 caster = this.level.method_14190(params.caster);
        this.level.method_8390(class_1309.class, this.type.getBounds(this.pos), e -> e.method_19538().method_1025(this.pos.method_46558()) < (double)this.radiusSq).forEach(entity -> this.applyBlightEffects(caster, (class_1309)entity));
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() % 3 != 0) {
            return true;
        }
        BlockPosUtils.iterableSphereHollow(this.pos, this.step).forEach(spherePos -> {
            if (Math.random() > this.decayChance) {
                return;
            }
            class_2680 state = this.level.method_8320((class_2338)spherePos);
            if (state.method_26215()) {
                return;
            }
            if (state.method_26164(EnchantedTags.Blocks.BLIGHT_DECAYABLE_BLOCKS)) {
                class_6880 holder = class_7923.field_41175.method_40260(EnchantedTags.Blocks.BLIGHT_DECAY_BLOCKS).method_40243(Enchanted.RANDOMSOURCE).orElse(null);
                if (holder == null) {
                    return;
                }
                this.level.method_8501((class_2338)spherePos, ((class_2248)holder.comp_349()).method_9564());
            } else if (state.method_26164(EnchantedTags.Blocks.BLIGHT_DECAYABLE_PLANTS)) {
                this.level.method_8501((class_2338)spherePos, class_2246.field_10428.method_9564());
            }
        });
        if (params.ticks() % 15 == 0) {
            this.level.method_8396(null, this.pos, class_3417.field_14671, class_3419.field_15250, 0.1f, 1.0f);
            this.level.method_14199((class_2394)EParticleTypes.BLIGHT_SEED.get(), (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        return this.step++ < this.radius;
    }

    @Override
    protected void saveAdditional(class_2487 tag, class_3218 level) {
        tag.method_10569("step", this.step);
    }

    @Override
    protected void loadAdditional(class_2487 tag, class_3218 level) {
        this.step = tag.method_10550("step");
    }

    protected void applyBlightEffects(class_1297 caster, class_1309 target) {
        class_6880 effectHolder;
        if (target instanceof class_1646) {
            class_1646 villager = (class_1646)target;
            if (Math.random() < this.zombieChance) {
                villager.method_29243(class_1299.field_6054, false);
                return;
            }
        }
        if ((effectHolder = (class_6880)class_7923.field_41174.method_40260(EnchantedTags.MobEffects.BLIGHT_EFFECTS).method_40243(Enchanted.RANDOMSOURCE).orElse(null)) == null) {
            return;
        }
        if (target != caster) {
            target.method_6092(new class_1293((class_1291)effectHolder.comp_349(), 100 + Enchanted.RANDOM.nextInt(101), Enchanted.RANDOM.nextInt(3)));
        }
    }
}

