/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.registry.EParticleTypes;
import net.favouriteless.enchanted.common.util.BlockPosUtils;
import net.favouriteless.enchanted.mixin.common.ZombieVillagerAccessor;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1641;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class FertilityRite
extends Rite {
    class_1291[] cured = new class_1291[]{class_1294.field_5919, class_1294.field_5916, class_1294.field_5903, class_1294.field_5899, class_1294.field_5911, class_1294.field_5920};
    public static final int TICKS_PER_BLOCK = 5;
    protected final int radius;
    protected final int radiusSq;
    protected final double bonemealChance;
    protected int step = 1;

    public FertilityRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, int radius, double bonemealChance) {
        super(baseParams, params);
        this.radius = radius;
        this.radiusSq = radius * radius;
        this.bonemealChance = bonemealChance;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        UUID caster = params.caster;
        this.level.method_8390(class_1309.class, this.type.getBounds(this.pos), e -> e.method_19538().method_1025(this.pos.method_46558()) < (double)this.radiusSq).forEach(entity -> this.applyCureEffects(caster, (class_1309)entity));
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() % 5 != 0) {
            return true;
        }
        BlockPosUtils.iterableSphereHollow(this.pos, this.step).forEach(spherePos -> {
            if (Math.random() > this.bonemealChance) {
                return;
            }
            class_2680 state = this.level.method_8320((class_2338)spherePos);
            if (state.method_26215()) {
                return;
            }
            class_2248 patt2357$temp = state.method_26204();
            if (patt2357$temp instanceof class_2256) {
                class_2256 block = (class_2256)patt2357$temp;
                block.method_9652(this.level, this.level.field_9229, (class_2338)spherePos, state);
            }
        });
        if (params.ticks() % 25 == 0) {
            this.level.method_8396(null, this.pos, class_3417.field_14671, class_3419.field_15250, 0.1f, 1.0f);
            this.level.method_14199((class_2394)EParticleTypes.FERTILITY_SEED.get(), (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        return this.step++ < this.radius;
    }

    @Override
    protected void saveAdditional(class_2487 tag, class_3218 level) {
        tag.method_10569("step", this.step);
    }

    @Override
    protected void loadAdditional(class_2487 tag, class_3218 level) {
        this.step = tag.method_10550("step");
    }

    protected void applyCureEffects(UUID casterUUID, class_1309 target) {
        if (target instanceof class_1641) {
            class_1641 villager = (class_1641)target;
            ((ZombieVillagerAccessor)villager).startConverting(casterUUID, Enchanted.RANDOM.nextInt(2401) + 3600);
            return;
        }
        ArrayList<class_1291> toRemove = new ArrayList<class_1291>();
        for (class_1291 effect : target.method_6088().keySet()) {
            if (!Arrays.asList(this.cured).contains(effect)) continue;
            toRemove.add(effect);
        }
        toRemove.forEach(arg_0 -> ((class_1309)target).method_6016(arg_0));
    }
}

