/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.registry.EParticleTypes;
import net.favouriteless.enchanted.common.util.BlockPosUtils;
import net.favouriteless.enchanted.mixin.common.SaplingBlockAccessor;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2473;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class ForestRite
extends Rite {
    private final int spacing;
    private final int maxSteps;
    private class_2473 sapling;
    private int step = 0;
    private final List<class_2338> usedPositions = new ArrayList<class_2338>();

    public ForestRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, int radius, int spacing) {
        super(baseParams, params);
        this.spacing = spacing;
        this.maxSteps = radius / spacing;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        this.sapling = this.getSapling();
        if (this.sapling == null) {
            return this.cancel();
        }
        this.level.method_8396(null, this.pos, class_3417.field_14905, class_3419.field_15250, 0.5f, 1.0f);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() % 20 != 0) {
            return true;
        }
        class_2680 state = this.sapling.method_9564();
        double r = (double)this.spacing / 1.7;
        double o = r / 2.0;
        BlockPosUtils.iterableCircleHollow(this.pos, this.step * this.spacing, this.spacing).forEach(circlePos -> {
            if (Math.random() < 0.3) {
                return;
            }
            circlePos.method_10100((int)Math.round(Math.random() * r - o), 0, (int)Math.round(Math.random() * r - o));
            class_2338 tree = this.level.method_8598(class_2902.class_2903.field_13203, (class_2338)circlePos);
            if (!this.level.method_8320(tree).method_45474() || !state.method_26184((class_4538)this.level, tree)) {
                return;
            }
            if (((SaplingBlockAccessor)this.sapling).getTreeGrower().method_11431(this.level, this.level.method_14178().method_12129(), tree, state, this.level.field_9229)) {
                this.level.method_8396(null, this.pos, class_3417.field_21905, class_3419.field_15250, 3.0f, 1.0f);
                this.usedPositions.add(tree);
            }
        });
        this.level.method_14199((class_2394)EParticleTypes.FERTILITY_SEED.get(), (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        return this.step++ < this.maxSteps;
    }

    @Override
    protected void saveAdditional(class_2487 tag, class_3218 level) {
        tag.method_10569("step", this.step);
        tag.method_10582("sapling", class_7923.field_41175.method_10221((Object)this.sapling).toString());
        tag.method_10566("used", (class_2520)class_2338.field_25064.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.usedPositions).getOrThrow(false, arg_0 -> ((Logger)Enchanted.LOG).error(arg_0)));
    }

    @Override
    protected void loadAdditional(class_2487 tag, class_3218 level) {
        this.step = tag.method_10550("step");
        this.sapling = (class_2473)class_7923.field_41175.method_10223(class_2960.method_12829((String)tag.method_10558("sapling")));
        this.usedPositions.addAll((Collection)class_2338.field_25064.listOf().parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("used")).getOrThrow(false, arg_0 -> ((Logger)Enchanted.LOG).error(arg_0)));
    }

    protected class_2473 getSapling() {
        List entities = this.level.method_18467(class_1542.class, this.type.getBounds(this.pos));
        for (class_1542 entity : entities) {
            class_1747 blockItem;
            class_1792 class_17922 = entity.method_6983().method_7909();
            if (!(class_17922 instanceof class_1747) || !((class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2473)) continue;
            class_2473 sapling = (class_2473)class_17922;
            this.consumeItem(entity);
            return sapling;
        }
        return null;
    }
}

