/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.function.Function;
import net.favouriteless.enchanted.client.particles.types.DoubleOptions;
import net.favouriteless.enchanted.common.circle_magic.rites.LocationTargetRite;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.registry.EBlocks;
import net.favouriteless.enchanted.common.init.registry.EParticleTypes;
import net.favouriteless.enchanted.common.stateobservers.ProtectionRiteObserver;
import net.favouriteless.enchanted.common.util.BlockPosUtils;
import net.favouriteless.stateobserver.api.StateObserver;
import net.favouriteless.stateobserver.api.StateObserverManager;
import net.minecraft.class_1937;
import net.minecraft.class_2213;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;

public class ProtectionRite
extends LocationTargetRite {
    private final int radius;
    private final int duration;
    private final boolean blocksPlayers;
    protected ProtectionRiteObserver observer = null;

    public ProtectionRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, int radius, int duration, boolean blocking) {
        super(baseParams, params);
        this.radius = radius;
        this.duration = duration;
        this.blocksPlayers = blocking;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        super.onStart(params);
        class_2248 block = this.blocksPlayers ? (class_2248)EBlocks.PROTECTION_BARRIER_BLOCKING.get() : (class_2248)EBlocks.PROTECTION_BARRIER.get();
        this.generateSphere(this.targetLevel, this.targetPos, state -> {
            if (!state.method_26227().method_15769()) {
                return state.method_26227().method_15772() == class_3612.field_15910 ? (class_2680)block.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : block.method_9564();
            }
            if (state.method_26215()) {
                return block.method_9564();
            }
            return null;
        });
        this.getOrCreateObserver(this.targetLevel, this.targetPos);
        this.targetLevel.method_8396(null, this.targetPos, class_3417.field_15119, class_3419.field_15250, 1.0f, 1.0f);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        this.observer.checkChanges();
        if (params.ticks() % 20 == 0 && this.targetPos != null) {
            this.targetLevel.method_14199((class_2394)new DoubleOptions(EParticleTypes.PROTECTION_SEED.get(), this.radius), (double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 0.6, (double)this.targetPos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        return params.ticks() < this.duration;
    }

    @Override
    protected void onStop(Rite.RiteParams params) {
        if (this.targetPos == null) {
            this.targetPos = this.pos;
        }
        if (this.targetLevel == null) {
            this.targetLevel = this.level;
        }
        this.targetLevel.method_8396(null, this.targetPos, class_3417.field_15119, class_3419.field_15250, 1.0f, 0.5f);
        StateObserverManager.get().removeObserver((StateObserver)this.observer);
        this.generateSphere(this.targetLevel, this.targetPos, state -> {
            if (state.method_27852((class_2248)EBlocks.PROTECTION_BARRIER.get()) || state.method_27852((class_2248)EBlocks.PROTECTION_BARRIER_BLOCKING.get())) {
                return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
            }
            return null;
        });
    }

    @Override
    protected void loadAdditional(class_2487 tag, class_3218 level) {
        super.loadAdditional(tag, level);
        this.getOrCreateObserver(this.targetLevel, this.targetPos);
    }

    protected void generateSphere(class_3218 level, class_2338 pos, Function<class_2680, class_2680> stateGetter) {
        BlockPosUtils.iterableSphereHollow(pos, this.radius).forEach(spherePos -> {
            class_2680 state = (class_2680)stateGetter.apply(level.method_8320((class_2338)spherePos));
            if (state != null) {
                level.method_8501((class_2338)spherePos, state);
            }
        });
    }

    protected void getOrCreateObserver(class_3218 level, class_2338 pos) {
        if (this.observer == null) {
            this.observer = (ProtectionRiteObserver)StateObserverManager.get().getObserver((class_1937)level, pos, ProtectionRiteObserver.class);
        }
        if (this.observer == null) {
            this.observer = (ProtectionRiteObserver)StateObserverManager.get().addObserver((StateObserver)new ProtectionRiteObserver((class_1937)level, pos, this.radius + 1, this.radius + 1, this.radius + 1, this.blocksPlayers ? (class_2213)EBlocks.PROTECTION_BARRIER_BLOCKING.get() : (class_2213)EBlocks.PROTECTION_BARRIER.get(), this.radius));
        }
    }
}

