/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.List;
import net.favouriteless.enchanted.api.curses.Curse;
import net.favouriteless.enchanted.api.curses.CurseSavedData;
import net.favouriteless.enchanted.api.familiars.FamiliarSavedData;
import net.favouriteless.enchanted.api.familiars.IFamiliarEntry;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.curses.CurseManager;
import net.favouriteless.enchanted.common.curses.CurseType;
import net.favouriteless.enchanted.common.init.registry.EFamiliarTypes;
import net.favouriteless.enchanted.common.init.registry.EParticleTypes;
import net.favouriteless.enchanted.common.init.registry.ESoundEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_3419;

public class RemoveCurseRite
extends Rite {
    public static final int RAISE = 300;
    public static final int START_SOUND = 190;
    private final CurseType<?> curse;

    public RemoveCurseRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, CurseType<?> curse) {
        super(baseParams, params);
        this.curse = curse;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        if (params.target == null) {
            return this.cancel();
        }
        this.level.method_14199((class_2394)EParticleTypes.REMOVE_CURSE_SEED.get(), (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 2.5, (double)this.pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() == 190) {
            this.level.method_8396(null, this.pos, ESoundEvents.REMOVE_CURSE.get(), class_3419.field_15250, 1.0f, 1.0f);
            return true;
        }
        if (params.ticks() == 300) {
            List<Curse> curses = CurseSavedData.get((class_1937)this.level).entries.get(params.target);
            if (curses == null) {
                return false;
            }
            int casterLevel = 0;
            FamiliarSavedData data = FamiliarSavedData.get((class_1937)this.level);
            IFamiliarEntry familiarEntry = data.getEntry(params.caster);
            if (familiarEntry != null && !familiarEntry.isDismissed() && familiarEntry.getType() == EFamiliarTypes.CAT) {
                ++casterLevel;
            }
            for (Curse curse : curses) {
                if (curse.getType() != this.curse) continue;
                int diff = casterLevel - curse.getLevel();
                double cureChance = 1.0 + (double)diff * 0.2;
                if (Math.random() < cureChance) {
                    CurseManager.removeCurse(this.level, curse);
                    break;
                }
                if (curse.getLevel() >= 2) break;
                curse.setLevel(curse.getLevel() + 1);
                break;
            }
            return false;
        }
        return true;
    }
}

