/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.entity.GoldChalkBlockEntity;
import net.favouriteless.enchanted.common.circle_magic.RiteManager;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.items.TaglockFilledItem;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4844;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class Rite {
    protected final RiteType type;
    protected final class_3218 level;
    protected final class_2338 pos;
    protected final int tickPower;
    private RiteParams params;
    private final Map<UUID, WeakReference<class_1297>> entityCache = new HashMap<UUID, WeakReference<class_1297>>();

    protected Rite(BaseRiteParams baseParams, RiteParams params) {
        this.type = baseParams.type;
        this.level = baseParams.level;
        this.pos = baseParams.pos;
        this.tickPower = baseParams.tickPower;
        this.params = params;
    }

    protected boolean onStart(RiteParams params) {
        return true;
    }

    protected boolean onTick(RiteParams params) {
        return false;
    }

    protected void onStop(RiteParams params) {
    }

    protected void saveAdditional(class_2487 tag, class_3218 level) {
    }

    protected void loadAdditional(class_2487 tag, class_3218 level) {
    }

    protected boolean cancel() {
        this.level.method_8396(null, this.pos, (class_3414)class_3417.field_14708.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
        for (class_1799 stack : this.params.consumedItems) {
            class_1542 entity = new class_1542((class_1937)this.level, (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5, stack);
            this.level.method_8649((class_1297)entity);
        }
        class_2586 class_25862 = this.level.method_8321(this.pos);
        if (class_25862 instanceof GoldChalkBlockEntity) {
            GoldChalkBlockEntity chalk = (GoldChalkBlockEntity)class_25862;
            chalk.detatch();
        }
        return false;
    }

    protected void consumeItem(class_1542 entity) {
        if (!entity.method_6983().method_31574(EItems.ATTUNED_STONE_CHARGED.get())) {
            this.params.consumedItems.add(entity.method_6983());
            entity.method_31472();
        } else {
            entity.method_6979(new class_1799((class_1935)EItems.ATTUNED_STONE.get(), entity.method_6983().method_7947()));
        }
        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15219, class_3419.field_15250, 1.0f, 1.0f);
        ((class_3218)entity.method_37908()).method_14199((class_2394)class_2398.field_11204, entity.method_23317(), entity.method_23318(), entity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nullable
    protected class_1297 findEntity(UUID uuid) {
        class_3222 out;
        if (this.entityCache.containsKey(uuid)) {
            out = (class_1297)this.entityCache.get(uuid).get();
            if (out != null) {
                return out;
            }
            this.entityCache.remove(uuid);
        }
        if ((out = this.level.method_8503().method_3760().method_14602(uuid)) != null) {
            return this.cacheAndReturn(uuid, (class_1297)out);
        }
        for (class_3218 dim : this.level.method_8503().method_3738()) {
            out = dim.method_14190(uuid);
            if (out == null) continue;
            return this.cacheAndReturn(uuid, (class_1297)out);
        }
        return null;
    }

    protected UUID findTargetUUID(class_3218 level, class_2338 pos, RiteParams params) {
        for (class_1799 stack : params.consumedItems) {
            if (!(stack.method_7909() instanceof TaglockFilledItem) || !stack.method_7948().method_10545("entity")) continue;
            return class_2512.method_25930((class_2520)stack.method_7969().method_10580("entity"));
        }
        return null;
    }

    protected void randomParticles(class_2394 options) {
        this.level.method_14199(options, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), 25, 1.5, 1.5, 1.5, 0.0);
    }

    public boolean tick() {
        if (this.level.method_8477(this.pos)) {
            GoldChalkBlockEntity chalk;
            class_2586 class_25862;
            if (!(this.tickPower <= 0 || (class_25862 = this.level.method_8321(this.pos)) instanceof GoldChalkBlockEntity && (chalk = (GoldChalkBlockEntity)class_25862).tryConsumePower(this.tickPower))) {
                return this.stop();
            }
            if (!this.onTick(this.params)) {
                return this.stop();
            }
        }
        ++this.params.ticks;
        return true;
    }

    public void start() {
        this.params.target = this.findTargetUUID(this.level, this.pos, this.params);
        if (!this.onStart(this.params)) {
            this.stop();
            RiteManager.removeRite(this.level, this);
        }
    }

    public boolean stop() {
        this.onStop(this.params);
        class_2586 class_25862 = this.level.method_8321(this.pos);
        if (class_25862 instanceof GoldChalkBlockEntity) {
            GoldChalkBlockEntity chalk = (GoldChalkBlockEntity)class_25862;
            chalk.detatch();
        }
        return false;
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10566("Params", (class_2520)RiteParams.CODEC.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.level.method_30349()), (Object)this.params).getOrThrow(false, arg_0 -> ((Logger)Enchanted.LOG).error(arg_0)));
        this.saveAdditional(tag, this.level);
        return tag;
    }

    public void load(class_2487 tag) {
        this.params = (RiteParams)RiteParams.CODEC.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.level.method_30349()), (Object)tag.method_10580("Params")).getOrThrow(false, arg_0 -> ((Logger)Enchanted.LOG).error(arg_0));
        this.loadAdditional(tag, this.level);
    }

    public RiteType getType() {
        return this.type;
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    private class_1297 cacheAndReturn(UUID uuid, class_1297 entity) {
        this.entityCache.put(uuid, new WeakReference<class_1297>(entity));
        return entity;
    }

    public record BaseRiteParams(RiteType type, class_3218 level, class_2338 pos, int tickPower) {
    }

    public static class RiteParams {
        public static final Codec<RiteParams> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("caster").forGetter(p -> p.caster), (App)class_4844.field_25122.optionalFieldOf("target").forGetter(p -> Optional.ofNullable(p.target)), (App)class_1799.field_24671.listOf().fieldOf("consumed_items").forGetter(p -> p.consumedItems), (App)Codec.INT.fieldOf("ticks").forGetter(p -> p.ticks)).apply((Applicative)instance, (caster, target, consumedItems, ticks) -> new RiteParams((UUID)caster, target.orElse(null), (List<class_1799>)consumedItems, (int)ticks)));
        public final List<class_1799> consumedItems;
        public final UUID caster;
        @Nullable
        public UUID target;
        private int ticks;

        private RiteParams(UUID caster, UUID target, List<class_1799> consumedItems, int ticks) {
            this.caster = caster;
            this.target = target;
            this.consumedItems = new ArrayList<class_1799>(consumedItems);
            this.ticks = ticks;
        }

        public static RiteParams of(UUID caster, List<class_1799> consumedItems) {
            return new RiteParams(caster, null, consumedItems, 0);
        }

        public static RiteParams empty() {
            return new RiteParams(null, null, List.of(), 0);
        }

        public int ticks() {
            return this.ticks;
        }
    }
}

